/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.metadata.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.repository.metadata.model.RepositoryMemberMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMirrorMetadata;

public class RepositoryMetadata
implements Serializable {
    private String version;
    private String url;
    private String id;
    private String name;
    private String layout;
    private String policy;
    private String localUrl;
    private String publicKey;
    private String repositoryMaintainerEmail;
    private long lastContentChange = 0L;
    private int contentChangeInterval = 0;
    private String mirrorListSource;
    private List<RepositoryMirrorMetadata> mirrors;
    private List<RepositoryMemberMetadata> memberRepositories;
    private String modelEncoding = "UTF-8";
    public static final String MODEL_VERSION = "1.0.0";
    public static final String LAYOUT_MAVEN2 = "maven2";
    public static final String LAYOUT_MAVEN1 = "maven1";
    public static final String POLICY_RELEASE = "release";
    public static final String POLICY_SNAPSHOT = "snapshot";
    public static final String POLICY_MIXED = "mixed";

    public void addMemberRepository(RepositoryMemberMetadata repositoryMemberMetadata) {
        this.getMemberRepositories().add(repositoryMemberMetadata);
    }

    public void addMirror(RepositoryMirrorMetadata repositoryMirrorMetadata) {
        this.getMirrors().add(repositoryMirrorMetadata);
    }

    public int getContentChangeInterval() {
        return this.contentChangeInterval;
    }

    public String getId() {
        return this.id;
    }

    public long getLastContentChange() {
        return this.lastContentChange;
    }

    public String getLayout() {
        return this.layout;
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public List<RepositoryMemberMetadata> getMemberRepositories() {
        if (this.memberRepositories == null) {
            this.memberRepositories = new ArrayList<RepositoryMemberMetadata>();
        }
        return this.memberRepositories;
    }

    public String getMirrorListSource() {
        return this.mirrorListSource;
    }

    public List<RepositoryMirrorMetadata> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<RepositoryMirrorMetadata>();
        }
        return this.mirrors;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getName() {
        return this.name;
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getRepositoryMaintainerEmail() {
        return this.repositoryMaintainerEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeMemberRepository(RepositoryMemberMetadata repositoryMemberMetadata) {
        this.getMemberRepositories().remove(repositoryMemberMetadata);
    }

    public void removeMirror(RepositoryMirrorMetadata repositoryMirrorMetadata) {
        this.getMirrors().remove(repositoryMirrorMetadata);
    }

    public void setContentChangeInterval(int contentChangeInterval) {
        this.contentChangeInterval = contentChangeInterval;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastContentChange(long lastContentChange) {
        this.lastContentChange = lastContentChange;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setLocalUrl(String localUrl) {
        this.localUrl = localUrl;
    }

    public void setMemberRepositories(List<RepositoryMemberMetadata> memberRepositories) {
        this.memberRepositories = memberRepositories;
    }

    public void setMirrorListSource(String mirrorListSource) {
        this.mirrorListSource = mirrorListSource;
    }

    public void setMirrors(List<RepositoryMirrorMetadata> mirrors) {
        this.mirrors = mirrors;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setRepositoryMaintainerEmail(String repositoryMaintainerEmail) {
        this.repositoryMaintainerEmail = repositoryMaintainerEmail;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

