/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.InsightService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.FixedRateWalkerThrottleController;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerThrottleController;
import org.sonatype.nexus.scheduling.AbstractNexusTask;
import org.sonatype.nexus.util.LinearNumberSequence;
import org.sonatype.nexus.util.NumberSequence;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.scheduling.schedules.HourlySchedule;
import org.sonatype.scheduling.schedules.Schedule;

@Named(value="HealthCheckTask")
public class HealthCheckTask
extends AbstractNexusTask<Object> {
    static final String TASK_TYPE = "HealthCheckTask";
    public static final String REPO_ID_KEY = "repoId";
    private final AtomicBoolean running;
    private State state = State.INIT;
    private Date now;
    private Date nextUploadTime;
    private Date nextDownloadTime;
    private boolean forceDeltaCheck;
    private final WebServerManager webServerManager;
    private WebServerService webServer;
    private final InsightService insight;
    private final HealthCheckTaskManager taskManager;
    private final ConfigService config;
    private final Walker walker;
    private final RepositoryRegistry repoRegistry;
    private final Provider<HealthCheckProcessor> rhcProcessorProvider;
    private final ScanWriterFactory scanWriterFactory;

    @Inject
    public HealthCheckTask(WebServerManager webServerManager, InsightService insight, HealthCheckTaskManager taskManager, ConfigService config, Walker walker, RepositoryRegistry reg, Provider<HealthCheckProcessor> rhcProcessorProvider, ScanWriterFactory scanWriterFactory) {
        this.webServerManager = webServerManager;
        this.insight = insight;
        this.taskManager = taskManager;
        this.config = config;
        this.walker = walker;
        this.repoRegistry = reg;
        this.rhcProcessorProvider = rhcProcessorProvider;
        this.scanWriterFactory = scanWriterFactory;
        this.running = new AtomicBoolean();
    }

    public boolean isExposed() {
        return true;
    }

    protected Object doRun() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                Object object = this.doRunSafe();
                return object;
            }
            finally {
                this.running.set(false);
            }
        }
        this.logger.debug("Health check for repository {} already running", (Object)this.getRepositoryId());
        return null;
    }

    private Object doRunSafe() throws Exception {
        String repoId = this.getRepositoryId();
        Repository repo = this.getRepository(repoId);
        if (repo == null) {
            this.logger.debug("Stopping task on deleted/unsupported repository {}", (Object)repoId);
            this.config.setEnabled(repoId, false);
            this.taskManager.stopTask(repoId);
            return null;
        }
        this.now = new Date();
        this.logger.debug("state = {}, forceDeltaCheck = {}, next report = {}, next scan = {}", new Object[]{this.state, this.forceDeltaCheck, this.nextDownloadTime, this.nextUploadTime});
        if (this.webServer == null) {
            this.webServer = this.webServerManager.addWebServer(repoId);
        }
        boolean deltasChecked = false;
        if (State.INIT.equals((Object)this.state)) {
            this.doDeltaCheck(repoId);
            this.state = !this.webServer.bundleExists() && this.nextDownloadTime != null && this.nextDownloadTime.before(this.nextUploadTime) ? State.GET_REPORT : State.PUT_SCAN;
            deltasChecked = true;
        } else if (this.forceDeltaCheck) {
            this.doDeltaCheck(repoId);
            deltasChecked = true;
        }
        this.forceDeltaCheck = false;
        switch (this.state) {
            case PUT_SCAN: {
                if (this.now.before(this.nextUploadTime) && !deltasChecked) {
                    this.doDeltaCheck(repoId);
                }
                if (!this.now.before(this.nextUploadTime)) {
                    if (!this.doUpload(repo, this.doScan(repo))) break;
                    this.state = State.GET_REPORT;
                    break;
                }
                if (this.webServer.bundleExists()) break;
                this.doDownload(repoId);
                break;
            }
            case GET_REPORT: {
                if (this.now.before(this.nextDownloadTime) && !deltasChecked) {
                    this.doDeltaCheck(repoId);
                }
                if (this.now.before(this.nextDownloadTime)) break;
                long overdue = this.now.getTime() - this.nextDownloadTime.getTime();
                if (this.doDownload(repoId)) {
                    this.state = State.PUT_SCAN;
                    String error = this.webServer.getBundleProperties().getProperty("errorMessage", "");
                    if (error.length() > 0) {
                        this.logger.warn("Received no health check report for repository {}: {}", (Object)repoId, (Object)error);
                        break;
                    }
                    this.logger.info("Received health check report for repository {}", (Object)repoId);
                    break;
                }
                if (overdue < 900000L) break;
                if (this.now.before(this.nextUploadTime)) {
                    throw new IOException("Failed to download health check report for repository " + repoId + ", " + overdue / 1000L / 60L + " minutes overdue");
                }
                this.state = State.PUT_SCAN;
                this.logger.debug("Received no health check report for repository {}, retrying with another scan", (Object)repoId);
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.state));
            }
        }
        this.updateSchedule();
        return null;
    }

    private File doScan(Repository repo) throws Exception {
        long start = System.currentTimeMillis();
        int scanRate = this.config.getScanRate();
        ResourceStoreRequest request = new ResourceStoreRequest("/", true, false);
        if (scanRate > 0) {
            FixedRateWalkerThrottleController throttleController = new FixedRateWalkerThrottleController(scanRate, (NumberSequence)new LinearNumberSequence(0L, 1L, 1L, 0L));
            request.getRequestContext().put(WalkerThrottleController.CONTEXT_KEY, (Object)throttleController);
        }
        DefaultWalkerContext wc = new DefaultWalkerContext(repo, request);
        HealthCheckProcessor rhcProcessor = (HealthCheckProcessor)((Object)this.rhcProcessorProvider.get());
        wc.getProcessors().add(rhcProcessor);
        File tmpFile = File.createTempFile("healthcheck", ".xml.gz");
        try {
            try (ScanWriter writer = this.scanWriterFactory.newWriter(tmpFile);){
                wc.getContext().put("rhc.scanWriter", writer);
                wc.getContext().put("rhc.scanRate", scanRate);
                this.walker.walk((WalkerContext)wc);
                if (!rhcProcessor.isStarted()) {
                    throw new TaskInterruptedException((Throwable)new RepositoryNotAvailableException(repo));
                }
                Throwable t = wc.getStopCause();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t != null) {
                    throw new IllegalStateException(t);
                }
            }
            File permFile = new File(tmpFile.getParent(), "healthcheck-" + repo.getId() + ".xml.gz");
            try {
                FileUtils.copyFile((File)tmpFile, (File)permFile);
            }
            catch (IOException e) {
                this.logger.warn("Could not backup health check scan to {}", (Object)permFile, (Object)e);
            }
        }
        catch (Exception e) {
            tmpFile.delete();
            throw e;
        }
        long time = System.currentTimeMillis() - start;
        this.logger.debug("Scanned repository {} in {} ms", (Object)repo.getId(), (Object)time);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpload(Repository repo, File scanFile) throws IOException {
        try (HttpResult result = this.insight.uploadScan(repo.getId(), scanFile);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to upload health check scan for repository " + repo.getId() + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, true);
        }
        finally {
            scanFile.delete();
        }
        return this.nextDownloadTime != null;
    }

    private void doDeltaCheck(String repositoryId) throws IOException {
        try (HttpResult result = this.insight.getNextRunDeltas(repositoryId);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to determine health check interval for repository " + repositoryId + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, false);
        }
    }

    private void updateTimesFromResult(HttpResult result, boolean expectDownloadTime) throws IOException {
        block6: {
            ObjectNode obj;
            long now = System.currentTimeMillis();
            this.now = new Date(now);
            try {
                obj = (ObjectNode)new ObjectMapper().readTree(result.getInputStream());
            }
            catch (RuntimeException e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                this.nextUploadTime = new Date(now + (long)(Integer.parseInt(obj.get("nextScanUpload").asText()) * 1000));
            }
            catch (Exception e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                this.nextDownloadTime = new Date(now + (long)(Integer.parseInt(obj.get("nextReportDownload").asText()) * 1000));
            }
            catch (Exception e) {
                if (!expectDownloadTime) break block6;
                this.nextDownloadTime = null;
                this.logger.warn("Health check scan was uploaded prematurely, retrying later");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDownload(String repositoryId) throws IOException {
        try (HttpResult result = this.insight.getHealthCheckBundle(repositoryId);){
            if (result.getStatusCode() == 404) {
                boolean bl = false;
                return bl;
            }
            if (!result.isSuccess()) {
                throw new IOException("Failed to download health check report for repository " + repositoryId + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.webServer.extractBundle(result.getInputStream());
        }
        return true;
    }

    private void updateSchedule() {
        Date nextTime;
        TaskUtil.checkInterruption();
        switch (this.state) {
            case GET_REPORT: {
                nextTime = this.nextDownloadTime;
                break;
            }
            case PUT_SCAN: {
                nextTime = this.nextUploadTime;
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.state));
            }
        }
        long now = System.currentTimeMillis();
        if (nextTime == null) {
            nextTime = new Date(now + 300000L);
        }
        nextTime = new Date(Math.max(nextTime.getTime(), System.currentTimeMillis() + 5000L));
        this.logger.debug("state = {}, next run = {}, next report = {}, next scan = {}", new Object[]{this.state, nextTime, this.nextDownloadTime, this.nextUploadTime});
        this.taskManager.updateTaskSchedule(this.getRepositoryId(), (Schedule)new HourlySchedule(nextTime, null), false);
    }

    protected String getAction() {
        return "Health Check Management for Repository " + this.getRepositoryId();
    }

    protected String getMessage() {
        return "Health Check Management for Repository " + this.getRepositoryId();
    }

    public String getRepositoryId() {
        return this.getParameter(REPO_ID_KEY);
    }

    private Repository getRepository(String repositoryId) {
        try {
            Repository repo = this.repoRegistry.getRepository(repositoryId);
            if (!HealthCheckTask.isSupported(repo)) {
                return null;
            }
            return repo;
        }
        catch (NoSuchRepositoryException e) {
            return null;
        }
    }

    public void forceDeltaCheck() {
        this.forceDeltaCheck = true;
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    void setNextUploadTime(Date nextUploadTime) {
        this.nextUploadTime = nextUploadTime;
    }

    void setNextDownloadTime(Date nextDownloadTime) {
        this.nextDownloadTime = nextDownloadTime;
    }

    public static boolean isSupported(Repository repo) {
        if (!repo.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            return false;
        }
        MavenRepository mavenRepo = (MavenRepository)repo.adaptToFacet(MavenRepository.class);
        if (mavenRepo != null) {
            return RepositoryPolicy.RELEASE.equals((Object)mavenRepo.getRepositoryPolicy());
        }
        return true;
    }

    static enum State {
        INIT,
        PUT_SCAN,
        GET_REPORT;

    }
}

