/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.base.Strings;
import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.client.ClientScanner;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;

@Named
public class HealthCheckProcessor
extends AbstractFileWalkerProcessor {
    public static final String CONTEXT_SCAN_WRITER = "rhc.scanWriter";
    public static final String CONTEXT_SCAN_RATE = "rhc.scanRate";
    private static final boolean ANONYMIZE_HEALTH_CHECK_ITEM_IDS = false;
    private Scan scan;
    private ReverseLookupTable revLookupTable;
    private long start;
    private int items;
    private int artifacts;
    private int snapshots;
    private ScanWriter scanWriter;
    private final Logger logger;
    private final Anonymizer scanAnonymizer;
    private final ClientScanner clientScanner;
    private final NexusIDService idService;
    private HealthCheckItemExtractor extractor = new HealthCheckItemExtractor();

    @Inject
    HealthCheckProcessor(Anonymizer anonymizer, ClientScanner clientScanner, NexusIDService idService, Logger logger) {
        this.scanAnonymizer = anonymizer;
        this.clientScanner = clientScanner;
        this.idService = idService;
        this.logger = logger;
    }

    public boolean isStarted() {
        return this.start != 0L;
    }

    public void afterWalk(WalkerContext context) throws Exception {
        super.afterWalk(context);
        this.scan.getSummary().setEndTime();
        this.scan.getSummary().setFiles(this.items);
        this.scan.getSummary().setArchives(this.artifacts);
        this.scan.getSummary().setSnapshots(this.snapshots);
        this.scanWriter.writeSummary(this.scan.getSummary());
        this.scanWriter.writeConfiguration(this.scan.getConfiguration());
        this.scanWriter.closeScan();
        this.logger.debug("Scan completed for repository {}: {} files, {} artifacts, {} ms", new Object[]{context.getRepository().getId(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        this.scan = null;
        this.revLookupTable = null;
    }

    public void beforeWalk(WalkerContext context) throws Exception {
        super.beforeWalk(context);
        this.start = System.currentTimeMillis();
        Object scanRate = context.getContext().get(CONTEXT_SCAN_RATE);
        this.scanWriter = (ScanWriter)context.getContext().get(CONTEXT_SCAN_WRITER);
        this.scan = new Scan();
        this.revLookupTable = new ReverseLookupTable();
        this.scanWriter.openScan(this.scan);
        Repository repo = context.getRepository();
        ProxyRepository proxyRepo = (ProxyRepository)repo.adaptToFacet(ProxyRepository.class);
        String proxyUrl = proxyRepo != null ? proxyRepo.getRemoteUrl() : null;
        com.sonatype.insight.scan.model.Repository repository = new com.sonatype.insight.scan.model.Repository(this.idService.getNexusID(), repo.getId(), repo.getName(), repo.getRepositoryContentClass().getId(), proxyUrl);
        this.scanWriter.writeRepository(repository);
        ScanConfiguration scanConfig = this.scan.getConfiguration();
        scanConfig.setProperty((Object)"procArch", (Object)"true");
        scanConfig.setProperty((Object)"operatingSystem", (Object)"true");
        scanConfig.setProperty((Object)"jreInfo", (Object)"true");
        scanConfig.setProperty((Object)"ipAddresses", (Object)"false");
        scanConfig.setProperty((Object)"hashFiles", (Object)"true");
        scanConfig.setProperty((Object)"fileSizes", (Object)"false");
        scanConfig.setProperty((Object)"lastAccess", (Object)"true");
        scanConfig.setProperty((Object)"anonymizeArtifactIds", (Object)String.valueOf(false));
        scanConfig.setProperty((Object)"scanRate", (Object)String.valueOf(scanRate));
        this.scan.getSummary().setStartTime();
        this.clientScanner.scan(new ClientScanRequest(this.scan));
        this.logger.debug("Scanning repository {} with rate of {} files per second", (Object)repo.getId(), scanRate);
    }

    protected void processFileItem(WalkerContext context, StorageFileItem fItem) throws Exception {
        if (this.logger.isDebugEnabled() && this.items % 1000 == 0 && this.items > 0) {
            this.logger.debug("Scan progress for repository {}: {} files, {} artifacts, {} ms", new Object[]{context.getRepository().getId(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        }
        ++this.items;
        HealthCheckItem healthCheckItem = this.extractor.extract(fItem, context.getRepository());
        if (healthCheckItem == null) {
            return;
        }
        String id = healthCheckItem.getId();
        DirectoryScanItem item = new DirectoryScanItem();
        item.setSha1(healthCheckItem.getSha1());
        item.setLastAccess(healthCheckItem.getLastAccess());
        item.setId(id);
        item.setPath(healthCheckItem.getPath());
        this.scanWriter.writeScanItem((ScanItem)item);
        ++this.artifacts;
        if (healthCheckItem.isSnapshot()) {
            ++this.snapshots;
        }
    }

    public void setHealthCheckItemExtractor(HealthCheckItemExtractor extractor) {
        this.extractor = extractor;
    }

    static class HealthCheckItemExtractor {
        HealthCheckItemExtractor() {
        }

        public HealthCheckItem extract(StorageFileItem item, Repository repo) {
            HealthCheckItemImpl healthCheckItem = new HealthCheckItemImpl(item, repo);
            if (healthCheckItem.getPath() == null || healthCheckItem.getSha1() == null) {
                return null;
            }
            if (healthCheckItem.getId() == null && repo.adaptToFacet(MavenRepository.class) != null) {
                return null;
            }
            return healthCheckItem;
        }

        private static class HealthCheckItemImpl
        implements HealthCheckItem {
            private final StorageFileItem item;
            private final Repository repo;
            private final Gav gav;
            private final String path;
            private final String id;
            private final boolean snapshot;

            public HealthCheckItemImpl(StorageFileItem item, Repository repo) {
                this.item = item;
                this.repo = repo;
                this.path = this.createPath();
                this.gav = this.createGav();
                this.id = this.createGavId(this.gav);
                this.snapshot = this.checkSnapshot();
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getSha1() {
                return this.item.getRepositoryItemAttributes().get("digest.sha1");
            }

            @Override
            public long getLastAccess() {
                return this.item.getLastRequested();
            }

            @Override
            public boolean isSnapshot() {
                return this.snapshot;
            }

            private Gav createGav() {
                MavenRepository mavenFacet = (MavenRepository)this.repo.adaptToFacet(MavenRepository.class);
                if (mavenFacet != null) {
                    return mavenFacet.getGavCalculator().pathToGav(this.item.getRepositoryItemUid().getPath());
                }
                return null;
            }

            private String createGavId(Gav gav) {
                if (gav == null || gav.isHash() || gav.isSignature() || "pom".equals(gav.getExtension())) {
                    return null;
                }
                String clearTextId = ArtifactId.maven((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getExtension(), (String)gav.getClassifier(), (String)gav.getVersion()).getId();
                return clearTextId;
            }

            private boolean checkSnapshot() {
                if (this.gav != null) {
                    return this.gav.isSnapshot();
                }
                return false;
            }

            @Override
            public String getPath() {
                return this.path;
            }

            private String createPath() {
                return Strings.isNullOrEmpty((String)this.item.getRemoteUrl()) ? null : this.cleanUrl(this.item.getRemoteUrl());
            }

            private String cleanUrl(String url) {
                int namedAnchorIndex;
                String result = url;
                int queryIndex = url.indexOf("?");
                if (queryIndex > -1) {
                    result = result.substring(0, queryIndex);
                }
                if ((namedAnchorIndex = result.indexOf("#")) > -1) {
                    result = result.substring(0, namedAnchorIndex);
                }
                return result.isEmpty() ? null : result;
            }
        }
    }
}

