/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.InsightService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckTask;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.events.GlobalRemoteConnectionSettingsChangedEvent;
import org.sonatype.nexus.configuration.application.events.GlobalRemoteProxySettingsChangedEvent;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named(value="HealthCheckEventInspector")
@Singleton
public class HealthCheckEventInspector
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final RepositoryRegistry repoRegistry;
    private final ConfigService config;
    private final HealthCheckTaskManager taskManager;
    private final InsightService insight;

    @Inject
    public HealthCheckEventInspector(RepositoryRegistry repoRegistry, ConfigService config, HealthCheckTaskManager taskManager, InsightService insight) {
        this.repoRegistry = repoRegistry;
        this.config = config;
        this.taskManager = taskManager;
        this.insight = insight;
    }

    @Subscribe
    public void on(NexusStartedEvent evt) {
        this.inspect((Event<?>)evt);
    }

    @Subscribe
    public void on(GlobalRemoteConnectionSettingsChangedEvent evt) {
        this.inspect((Event<?>)evt);
    }

    @Subscribe
    public void on(GlobalRemoteProxySettingsChangedEvent evt) {
        this.inspect((Event<?>)evt);
    }

    protected void inspect(Event<?> evt) {
        if (evt instanceof NexusStartedEvent) {
            this.taskManager.removeDuplicates();
            for (Repository repo : this.repoRegistry.getRepositories()) {
                if (!HealthCheckTask.isSupported(repo)) continue;
                if (this.config.isEnabled(repo.getId())) {
                    this.taskManager.scheduleTask(repo.getId());
                    continue;
                }
                this.taskManager.stopTask(repo.getId());
            }
        } else if (evt instanceof GlobalRemoteConnectionSettingsChangedEvent || evt instanceof GlobalRemoteProxySettingsChangedEvent) {
            this.insight.resetHttpClient();
        }
    }
}

