/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
public class WebServerServiceImpl
extends ComponentSupport
implements WebServerService {
    private static final String REPORT_PROPS = "report.properties";
    private File rootDir;
    private final MimeSupport mimeSupport;

    @Inject
    public WebServerServiceImpl(MimeSupport mimeSupport) {
        this.mimeSupport = mimeSupport;
    }

    @Override
    public void initialize(File rootDir, String repositoryId) {
        this.rootDir = new File(rootDir, repositoryId).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractBundle(InputStream inputStream) throws IOException {
        HashSet<String> reportFiles = new HashSet<String>();
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(inputStream));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String path = entry.getName().replace('\\', '/');
                reportFiles.add(path);
                this.extract(path, zis);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zis);
        this.delete(this.rootDir, "", reportFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(String path, InputStream is) throws IOException {
        File file = new File(this.rootDir, path);
        File dir = file.getParentFile();
        for (int i = 0; i < 10 && !dir.exists(); ++i) {
            DirSupport.mkdir((Path)dir.toPath());
        }
        File tmp = File.createTempFile("rhc", ".tmp", dir);
        try {
            OutputStream os = this.openOutput(tmp);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
            if (!tmp.renameTo(file)) {
                FileNotFoundException error = null;
                for (int i = 0; i < 3; ++i) {
                    try {
                        FileUtils.copyFile((File)tmp, (File)file, (boolean)false);
                        break;
                    }
                    catch (FileNotFoundException e) {
                        if (error != null) continue;
                        error = e;
                        continue;
                    }
                }
                if (error != null) {
                    throw error;
                }
            }
        }
        finally {
            tmp.delete();
        }
    }

    private OutputStream openOutput(File dst) throws IOException {
        FileNotFoundException error = null;
        for (int i = 0; i < 3; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(50 * (i + 1));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                return new FileOutputStream(dst);
            }
            catch (FileNotFoundException e) {
                if (error != null) continue;
                error = e;
                continue;
            }
        }
        throw error;
    }

    private boolean delete(File file, String path, Set<String> excludes) {
        String[] children = file.list();
        if (children != null) {
            int childCount = children.length;
            String prefix = path.length() > 0 ? path + '/' : "";
            for (String child : children) {
                String childPath = prefix + child;
                if (!this.delete(new File(file, child), childPath, excludes)) continue;
                --childCount;
            }
            if (childCount > 0) {
                return false;
            }
        } else if (excludes.contains(path)) {
            return false;
        }
        return file.delete();
    }

    @Override
    public WebServerService.ContentItem getContentItem(String path) throws IOException {
        this.log.debug("Getting path {}", (Object)path);
        path = FilenameUtils.separatorsToUnix((String)path);
        if (path == null || path.contains("../")) {
            return null;
        }
        File file = new File(this.rootDir, path);
        this.log.debug("Getting file {}", (Object)file.getAbsolutePath());
        if (file.isFile()) {
            String mimeType = this.mimeSupport.guessMimeTypeFromPath(file.getAbsolutePath());
            return new WebServerService.ContentItem(file, mimeType);
        }
        return null;
    }

    @Override
    public boolean bundleExists() {
        try {
            if (this.getContentItem(REPORT_PROPS) != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getBundleProperties() {
        FileInputStream is;
        Properties props;
        block5: {
            props = new Properties();
            is = null;
            try {
                WebServerService.ContentItem ci = this.getContentItem(REPORT_PROPS);
                if (ci == null) break block5;
                if (ci.exists()) {
                    is = new FileInputStream(ci.getFile());
                    props.load(is);
                }
                props.setProperty("timestamp", Long.toHexString(ci.getLastModified()));
            }
            catch (IOException e) {
                try {
                    this.log.error("Unable to read report properties file from {}", (Object)new File(this.rootDir, REPORT_PROPS), (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly(is);
        return props;
    }
}

