/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class WebServerManagerImpl
extends ComponentSupport
implements WebServerManager {
    private final Provider<WebServerService> webServerProvider;
    private final ConcurrentMap<String, WebServerService> webServers = new ConcurrentHashMap<String, WebServerService>();
    private final File workDir;

    @Inject
    public WebServerManagerImpl(Provider<WebServerService> webServerProvider, ApplicationDirectories applicationDirectories) {
        this.webServerProvider = webServerProvider;
        this.workDir = applicationDirectories.getWorkDirectory("health-check");
    }

    @Override
    public WebServerService addWebServer(String repositoryId) {
        WebServerService webServer = (WebServerService)this.webServerProvider.get();
        webServer.initialize(this.workDir, repositoryId);
        WebServerService previous = this.webServers.putIfAbsent(repositoryId, webServer);
        if (previous == null) {
            this.log.debug("Started report server for repository {}", (Object)repositoryId);
        }
        return previous == null ? webServer : previous;
    }

    @Override
    public WebServerService getWebServer(String repositoryId) {
        return (WebServerService)this.webServers.get(repositoryId);
    }

    @Override
    public void removeWebServer(String repositoryId) {
        if (this.webServers.remove(repositoryId) != null) {
            this.log.debug("Stopped report server for repository {}", (Object)repositoryId);
        }
    }
}

