/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.UrlService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;

@Named
@Singleton
public class UrlServiceImpl
implements UrlService {
    private final ConfigService config;
    private final LicenseService license;
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    @Inject
    public UrlServiceImpl(ConfigService config, LicenseService license) {
        this.config = config;
        this.license = license;
    }

    @Override
    public String getReportUrl(String nexusInstanceId, String repositoryId) {
        return this.buildInsightUrl(this.getTimestampMap(), "/rest/rhc/report/", nexusInstanceId, repositoryId);
    }

    @Override
    public String getScanUrl(String nexusInstanceId, String repositoryId) {
        return this.buildInsightUrl(this.getTimestampMap(), "/rest/rhc/scan/", nexusInstanceId, repositoryId);
    }

    @Override
    public String getGAExtrasUrl(String nexusInstanceId) {
        return this.buildInsightUrl(null, "/rest/rhc/extras/galist/", nexusInstanceId);
    }

    @Override
    public String getGAVExtrasUrl(String nexusInstanceId, boolean alerts) {
        if (alerts && !this.license.isSearchAlertDataSupported()) {
            alerts = false;
        }
        return this.buildInsightUrl(alerts ? Collections.singletonMap("alerts", "true") : null, "/rest/rhc/extras/gav/", nexusInstanceId);
    }

    @Override
    public String getComponentDetailsUrl(String nexusInstanceId, String hash, ComponentIdentifier componentIdentifier) throws IOException {
        Map<String, String> queryParams = Collections.singletonMap("componentIdentifier", this.jsonObjectMapper.writeValueAsString((Object)componentIdentifier));
        return this.buildInsightUrl(queryParams, "/rest/rhc/extras/componentDetails/", nexusInstanceId, hash);
    }

    private String buildInsightUrl(Map<String, String> queryParams, String base, String ... segments) {
        String licenseId;
        UriBuilder builder = UriBuilder.fromPath((String)this.config.getInsightUrl()).path(base);
        if (segments != null) {
            builder.segment(segments);
        }
        if (queryParams != null) {
            for (Map.Entry<String, String> queryParam : queryParams.entrySet()) {
                builder.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
            }
        }
        if ((licenseId = this.license.getLicenseId()) != null) {
            builder.queryParam("licenseId", new Object[]{licenseId});
        }
        return builder.build(new Object[0]).toString();
    }

    private Map<String, String> getTimestampMap() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = format.format(new Date());
        Map<String, String> result = Collections.singletonMap("timestamp", timestamp);
        return result;
    }
}

