/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.security.configuration.SecurityConfigurationManager;
import org.sonatype.sisu.siesta.common.error.WebApplicationMessageException;

@Named
@Singleton
public class SecurityServiceImpl
implements SecurityService {
    private final SecurityConfigurationManager securityConfig;

    @Inject
    public SecurityServiceImpl(SecurityConfigurationManager securityConfig) {
        this.securityConfig = securityConfig;
    }

    @Override
    public boolean isAnonymousUser(HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        String anonUsername = this.securityConfig.getAnonymousUsername();
        if (StringUtils.isEmpty((String)anonUsername)) {
            anonUsername = "anonymous";
        }
        return subject == null || Boolean.TRUE.equals(request.getAttribute("nexus.anonymous")) || anonUsername.equals(subject.getPrincipal());
    }

    @Override
    public void blockAnonymousUser(HttpServletRequest request) {
        if (this.isAnonymousUser(request)) {
            throw new WebApplicationMessageException(Response.Status.FORBIDDEN, "Anonymous users may never access sensitive information");
        }
    }
}

