/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckComponentDetails;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.GADetailDTO;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.GADetailListDTO;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.GAVDetailDTO;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.GAVDetailListDTO;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.ArtifactInfo;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.GA;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.GAV;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.MostPopularVersion;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.InsightService;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.service.UrlService;
import com.sonatype.nexus.plugins.healthcheck.service.impl.HttpResultImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class InsightServiceImpl
extends ComponentSupport
implements InsightService {
    private final UrlService urlService;
    private final NexusIDService idService;
    private final Hc4Provider hc4Provider;
    private final ObjectMapper mapper = new ObjectMapper();
    private HttpClient httpClient;

    @Inject
    InsightServiceImpl(UrlService urlService, NexusIDService idService, Hc4Provider hc4Provider) {
        this.urlService = (UrlService)Preconditions.checkNotNull((Object)urlService);
        this.idService = (NexusIDService)Preconditions.checkNotNull((Object)idService);
        this.hc4Provider = (Hc4Provider)Preconditions.checkNotNull((Object)hc4Provider);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public HttpResult uploadScan(String repositoryId, File scanFile) throws IOException {
        return this.doPut(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryId), scanFile);
    }

    @Override
    public HttpResult getNextRunDeltas(String repositoryId) throws IOException {
        return this.doGet(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryId));
    }

    @Override
    public HttpResult getHealthCheckBundle(String repositoryId) throws IOException {
        return this.doGet(this.urlService.getReportUrl(this.idService.getNexusID(), repositoryId));
    }

    @Override
    public void disableScan(String repositoryId) throws IOException {
        this.doDelete(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryId)).close();
    }

    @Override
    public HttpResult getComponentDetails(String hash, ComponentIdentifier componentIdentifier) throws IOException {
        return this.doGet(this.urlService.getComponentDetailsUrl(this.idService.getNexusID(), hash, componentIdentifier));
    }

    @Override
    public HttpResult getGAExtras(GADetailListDTO gas) throws IOException {
        ArrayList<GA> insightGAs = new ArrayList<GA>();
        if (gas.getGas() != null) {
            for (GADetailDTO ga : gas.getGas()) {
                insightGAs.add(new GA(ga.getGroupId(), ga.getArtifactId()));
            }
        }
        return this.doPost(this.urlService.getGAExtrasUrl(this.idService.getNexusID()), this.mapper.writeValueAsString(insightGAs), ContentType.APPLICATION_JSON);
    }

    @Override
    public GADetailListDTO convertGAExtras(HttpResult httpResult) throws IOException {
        GADetailListDTO gaList = new GADetailListDTO();
        if (httpResult.isSuccess()) {
            List results = (List)this.mapper.readValue(httpResult.getInputStream(), (TypeReference)new TypeReference<List<MostPopularVersion>>(){});
            for (MostPopularVersion result : results) {
                gaList.addGa(new GADetailDTO(result.getGa().getGroupId(), result.getGa().getArtifactId(), result.getMostPopularVersion(), result.getCapped()));
            }
        }
        return gaList;
    }

    @Override
    public HttpResult getGAVExtras(GAVDetailListDTO gavs, boolean alerts) throws IOException {
        ArrayList<GAV> insightGAVs = new ArrayList<GAV>();
        if (gavs.getGavs() != null) {
            for (GAVDetailDTO gav : gavs.getGavs()) {
                insightGAVs.add(new GAV(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
            }
        }
        return this.doPost(this.urlService.getGAVExtrasUrl(this.idService.getNexusID(), alerts), this.mapper.writeValueAsString(insightGAVs), ContentType.APPLICATION_JSON);
    }

    @Override
    public GAVDetailListDTO convertGAVExtras(HttpResult httpResult) throws IOException {
        GAVDetailListDTO gavList = new GAVDetailListDTO();
        if (httpResult.isSuccess()) {
            List results = (List)this.mapper.readValue(httpResult.getInputStream(), (TypeReference)new TypeReference<List<ArtifactInfo>>(){});
            long now = System.currentTimeMillis();
            for (ArtifactInfo result : results) {
                Long age = null;
                if (result.getCreateTime() != null) {
                    age = Math.max(0L, now - result.getCreateTime());
                }
                gavList.addGav(new GAVDetailDTO(result.getGAV().getGroupId(), result.getGAV().getArtifactId(), result.getGAV().getVersion(), age, result.getPopularity(), result.getCapped(), result.getCriticalSecurityAlerts(), result.getSevereSecurityAlerts(), result.getModerateSecurityAlerts(), this.mapLicenseThreat(result.getLicenseCategoryId()), result.getLicenseThreatName(), result.getCappedAlerts()));
            }
        }
        return gavList;
    }

    @Override
    public RepoHealthCheckComponentDetails convertComponentDetails(HttpResult result) throws IOException {
        return (RepoHealthCheckComponentDetails)this.mapper.readValue(result.getInputStream(), RepoHealthCheckComponentDetails.class);
    }

    private Integer mapLicenseThreat(String licenseThreat) {
        if (licenseThreat == null) {
            return null;
        }
        if ("COPYLEFT".equalsIgnoreCase(licenseThreat)) {
            return 4;
        }
        if ("WEAKCOPYLEFT".equalsIgnoreCase(licenseThreat)) {
            return 2;
        }
        if ("LIBERAL".equalsIgnoreCase(licenseThreat)) {
            return 1;
        }
        return 3;
    }

    private HttpResult doGet(String url) throws IOException {
        this.log.debug("Calling into server ({}) with GET", (Object)url);
        HttpGet method = new HttpGet(url);
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doPut(String url, File body) throws IOException {
        this.log.debug("Calling into server ({}) with PUT", (Object)url);
        HttpPut method = new HttpPut(url);
        method.setEntity((HttpEntity)new FileEntity(body, (ContentType)null));
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doPost(String url, String body, ContentType contentType) throws IOException {
        this.log.debug("Calling into server ({}) with POST", (Object)url);
        HttpPost method = new HttpPost(url);
        method.setEntity((HttpEntity)new StringEntity(body, contentType));
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doDelete(String url) throws IOException {
        this.log.debug("Calling into server ({}) with DELETE", (Object)url);
        HttpDelete method = new HttpDelete(url);
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    protected HttpResponse execute(HttpUriRequest method) throws IOException {
        return this.getHttpClient().execute(method);
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.hc4Provider.createHttpClient();
        }
        return this.httpClient;
    }

    @Override
    public synchronized void resetHttpClient() {
        if (this.httpClient != null) {
            this.log.debug("Requesting reset of HTTP client");
            this.httpClient = null;
        }
    }
}

