/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.InsightService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.scheduling.NoSuchTaskException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.schedules.HourlySchedule;
import org.sonatype.scheduling.schedules.Schedule;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class HealthCheckTaskManagerImpl
extends ComponentSupport
implements HealthCheckTaskManager {
    private final NexusScheduler nexusScheduler;
    private final WebServerManager webServerManager;
    private final InsightService insight;
    private final EventBus eventBus;
    private final ConfigService configService;
    private final RepositoryRegistry repositoryRegistry;
    private final Map<String, String> repoIdTaskIdMap = new HashMap<String, String>();
    private boolean configuredForNewRepositories = false;

    @Inject
    public HealthCheckTaskManagerImpl(NexusScheduler nexusScheduler, WebServerManager webServermanager, InsightService insight, EventBus eventBus, ConfigService configService, RepositoryRegistry repositoryRegistry) {
        this.nexusScheduler = nexusScheduler;
        this.webServerManager = webServermanager;
        this.insight = insight;
        this.eventBus = eventBus;
        this.eventBus.register((Object)this);
        this.configService = configService;
        this.repositoryRegistry = repositoryRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledTask<?> getTask(String repositoryId) {
        Map<String, String> map = this.repoIdTaskIdMap;
        synchronized (map) {
            ScheduledTask<?> task = this.getTaskInMem(repositoryId);
            if (task != null) {
                return task;
            }
            Map taskLists = this.nexusScheduler.getAllTasks();
            for (List taskList : taskLists.values()) {
                for (ScheduledTask taskItem : taskList) {
                    if (!(taskItem.getTask() instanceof HealthCheckTask) || !repositoryId.equals(taskItem.getTaskParams().get("repoId"))) continue;
                    this.repoIdTaskIdMap.put(repositoryId, taskItem.getId());
                    return taskItem;
                }
            }
            return null;
        }
    }

    @Override
    public List<ScheduledTask<?>> getTasks() {
        ArrayList tasks = Lists.newArrayList();
        Map taskLists = this.nexusScheduler.getAllTasks();
        for (List taskList : taskLists.values()) {
            for (ScheduledTask taskItem : taskList) {
                if (!(taskItem.getTask() instanceof HealthCheckTask)) continue;
                tasks.add(taskItem);
            }
        }
        return tasks;
    }

    private ScheduledTask<?> getTaskInMem(String repositoryId) {
        try {
            String taskId = this.repoIdTaskIdMap.get(repositoryId);
            if (taskId != null) {
                return this.nexusScheduler.getTaskById(taskId);
            }
        }
        catch (NoSuchTaskException e) {
            this.repoIdTaskIdMap.remove(repositoryId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledTask<?> scheduleTask(String repositoryId) {
        Map<String, String> map = this.repoIdTaskIdMap;
        synchronized (map) {
            ScheduledTask task = this.getTaskInMem(repositoryId);
            if (task != null) {
                return task;
            }
            task = this.getTask(repositoryId);
            Calendar cal = Calendar.getInstance();
            cal.add(13, 5);
            Date start = cal.getTime();
            HourlySchedule schedule = new HourlySchedule(start, null);
            if (task != null) {
                this.updateTaskSchedule(repositoryId, (Schedule)schedule, true);
            } else {
                NexusTask nexusTask = (NexusTask)this.nexusScheduler.createTaskInstance(HealthCheckTask.class);
                nexusTask.addParameter("repoId", repositoryId);
                task = this.nexusScheduler.schedule("Health Check: " + repositoryId, nexusTask, (Schedule)schedule);
                this.log.debug("Starting task '{}'", (Object)task.getName());
                this.repoIdTaskIdMap.put(repositoryId, task.getId());
            }
            this.webServerManager.addWebServer(repositoryId);
            this.log.info("Enabled health check for repository {}", (Object)repositoryId);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTask(String repositoryId) {
        Map<String, String> map = this.repoIdTaskIdMap;
        synchronized (map) {
            ScheduledTask<?> task = this.getTask(repositoryId);
            if (task != null) {
                this.log.debug("Stopping task '{}'", (Object)task.getName());
                this.repoIdTaskIdMap.remove(repositoryId);
                try {
                    this.insight.disableScan(repositoryId);
                }
                catch (IOException e) {
                    this.log.warn("Unable to unsubscribe health check for repository {}", (Object)repositoryId, (Object)e);
                }
                task.cancel();
                this.webServerManager.removeWebServer(repositoryId);
                this.log.info("Disabled health check for repository {}", (Object)repositoryId);
            }
        }
    }

    @Override
    public void updateTaskSchedule(String repositoryId, Schedule schedule, boolean reset) {
        ScheduledTask<?> task = this.getTask(repositoryId);
        if (task != null) {
            this.updateTaskSchedule(task, schedule, reset);
        }
    }

    private void updateTaskSchedule(ScheduledTask<?> task, Schedule schedule, boolean reset) {
        this.log.debug("Updating schedule of task '{}'", (Object)task.getName());
        task.setSchedule(schedule);
        this.nexusScheduler.updateSchedule(task);
        if (reset) {
            task.reset();
        }
    }

    @Override
    public void refreshTaskSchedules() {
        Map taskLists = this.nexusScheduler.getAllTasks();
        Date next = new Date(System.currentTimeMillis() + 10000L);
        for (List taskList : taskLists.values()) {
            for (ScheduledTask taskItem : taskList) {
                if (!(taskItem.getTask() instanceof HealthCheckTask)) continue;
                ((HealthCheckTask)((Object)taskItem.getTask())).forceDeltaCheck();
                this.updateTaskSchedule(taskItem, (Schedule)new HourlySchedule(next, null), true);
            }
        }
    }

    @Override
    public void removeDuplicates() {
        Map taskLists = this.nexusScheduler.getAllTasks();
        HashMap tasksByRepoId = new HashMap();
        for (List tasks : taskLists.values()) {
            for (ScheduledTask task : tasks) {
                if (!(task.getTask() instanceof HealthCheckTask) || tasksByRepoId.put(task.getTaskParams().get("repoId"), task) == null) continue;
                this.log.debug("Stopping duplicate task '{}'", (Object)task.getName());
                task.cancel();
            }
        }
    }

    @Override
    public void configure(boolean configuredForNewRepositories, boolean configuredForExistingRepositories) {
        this.configuredForNewRepositories = configuredForNewRepositories;
        if (configuredForExistingRepositories) {
            for (Repository repository : this.repositoryRegistry.getRepositories()) {
                this.maybeScheduleTask(repository, true);
            }
        }
    }

    @Override
    public boolean isConfiguredForNewRepositories() {
        return this.configuredForNewRepositories;
    }

    @Subscribe
    public void on(RepositoryRegistryEventAdd evt) {
        if (this.configuredForNewRepositories) {
            this.maybeScheduleTask(evt.getRepository(), false);
        }
    }

    private boolean isCandidateRepository(Repository repository, boolean initializing) {
        MavenRepository mavenRepository = (MavenRepository)repository.adaptToFacet(MavenRepository.class);
        String repositoryId = repository.getId();
        boolean alreadyConfigured = this.configService.isConfigured(repositoryId);
        boolean inService = repository.getLocalStatus().equals((Object)LocalStatus.IN_SERVICE);
        boolean isSupported = HealthCheckTask.isSupported(repository);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking repository: {}", (Object)repositoryId);
            this.log.debug(" Is supported repository: {}", (Object)isSupported);
            this.log.debug(" Is mavenRepository: {}", (Object)(null != mavenRepository ? 1 : 0));
            this.log.debug(" Is initializing: {}", (Object)initializing);
            this.log.debug(" Is configured already: {}", (Object)alreadyConfigured);
            this.log.debug(" Is in service: {}", (Object)inService);
            this.log.debug(" Has existing task: {}", (Object)(null != this.getTask(repositoryId) ? 1 : 0));
        }
        return isSupported && (initializing || !alreadyConfigured) && inService && this.getTask(repositoryId) == null;
    }

    private void maybeScheduleTask(Repository repository, boolean initializing) {
        if (this.isCandidateRepository(repository, initializing)) {
            this.scheduleTask(repository.getId());
            this.configService.setEnabled(repository.getId(), true);
        }
    }
}

