/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class EulaServiceImpl
extends ComponentSupport
implements EulaService {
    private static final String EULA_ACCEPTED_KEY = "eulaAccepted";

    @Override
    public void acceptEula() {
        try {
            Preferences preferences = EulaServiceImpl.getPreferences();
            preferences.putBoolean(EULA_ACCEPTED_KEY, true);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            this.log.warn("Could not flush EULA preferences", (Throwable)e);
        }
    }

    @Override
    public void clearEula() {
        try {
            Preferences preferences = EulaServiceImpl.getPreferences();
            preferences.remove(EULA_ACCEPTED_KEY);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            this.log.warn("Could not flush EULA preferences", (Throwable)e);
        }
    }

    @Override
    public boolean isEulaAccepted() {
        try {
            Preferences preferences = EulaServiceImpl.getPreferences();
            Preferences.userRoot().sync();
            preferences.sync();
            return preferences.getBoolean(EULA_ACCEPTED_KEY, false);
        }
        catch (BackingStoreException e) {
            this.log.warn("Could not sync EULA preferences", (Throwable)e);
            return false;
        }
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(EulaService.class);
    }
}

