/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.impl.ConfigServiceMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.ObjectName;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class ConfigServiceImpl
extends ComponentSupport
implements ConfigService,
ConfigServiceMXBean {
    private final LicenseService license;
    private final File propFile;
    private long propFileTimestamp;
    private long propFileLastScan;
    private long propFileScanInterval;
    private Properties properties = new Properties();
    public static final String FILE_NAME = "healthcheck.properties";
    private static final long DEFAULT_SCAN_INTERVAL = 60000L;
    private static final int DEFAULT_SCAN_RATE = 100;
    private static final int DEFAULT_HTTP_TIMEOUT = -1;
    private static final String SCAN_RATE_PROP = "scan.rate";
    private static final String HTTP_TIMEOUT_PROP = "http.timeout";
    private static final String ENABLED_PROP = "{repoId}.enabled";
    private static final String INSIGHT_URL_PROP = "insight.url";

    @Inject
    ConfigServiceImpl(NexusConfiguration nexusConfig, LicenseService license) {
        this.license = license;
        this.propFile = new File(nexusConfig.getConfigurationDirectory(), FILE_NAME);
        this.propFileTimestamp = -1L;
        this.propFileScanInterval = 60000L;
        this.propFileLastScan = System.currentTimeMillis();
        this.loadProperties();
        try {
            ObjectName jmxName = ObjectName.getInstance("com.sonatype.nexus.plugins.healthcheck", "name", "Configuration");
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmxName);
        }
        catch (Exception e) {
            this.log.warn("Could not register JMX bean for health check configuration", (Throwable)e);
        }
    }

    @Override
    public String getInsightUrl() {
        this.syncProperties(false);
        String val = this.properties.getProperty(INSIGHT_URL_PROP, this.license.getDefaultInsightUrl());
        if (val != null && val.endsWith("/")) {
            return val.substring(0, val.length() - 1);
        }
        return val;
    }

    @Override
    public boolean isEnabled(String repoId) {
        this.syncProperties(false);
        return "true".equals(this.properties.get(ENABLED_PROP.replace("{repoId}", repoId)));
    }

    @Override
    public boolean isConfigured(String repoId) {
        this.syncProperties(false);
        return null != this.properties.get(ENABLED_PROP.replace("{repoId}", repoId));
    }

    @Override
    public void setEnabled(String repoId, boolean enabled) {
        this.syncProperties(true);
        this.properties.put(ENABLED_PROP.replace("{repoId}", repoId), enabled ? "true" : "false");
        this.saveProperties();
    }

    @Override
    public int getScanRate() {
        this.syncProperties(true);
        try {
            return Integer.parseInt(this.properties.getProperty(SCAN_RATE_PROP, Integer.toString(100)));
        }
        catch (NumberFormatException e) {
            this.log.warn("Invalid scan rate, defaulting to {} files per second", (Object)100);
            return 100;
        }
    }

    @Override
    public void setScanRate(int scanRate) {
        this.syncProperties(true);
        this.properties.setProperty(SCAN_RATE_PROP, Integer.toString(scanRate));
        this.saveProperties();
    }

    @Override
    public int getHttpTimeout() {
        this.syncProperties(true);
        try {
            return Integer.parseInt(this.properties.getProperty(HTTP_TIMEOUT_PROP, Integer.toString(-1)));
        }
        catch (NumberFormatException e) {
            this.log.warn("Invalid HTTP timeout, defaulting to {} seconds", (Object)-1);
            return -1;
        }
    }

    @Override
    public void setHttpTimeout(int httpTimeout) {
        this.syncProperties(true);
        this.properties.setProperty(HTTP_TIMEOUT_PROP, Integer.toString(httpTimeout));
        this.saveProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadProperties() {
        Properties properties;
        block8: {
            block6: {
                this.log.debug("Loading health check configuration from {}", (Object)this.propFile);
                properties = new Properties();
                if (!this.propFile.isFile()) break block6;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(this.propFile);
                    properties.load(fis);
                }
                catch (IOException e) {
                    try {
                        this.log.error("Unable to load health check configuration from {}", (Object)this.propFile, (Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                IOUtils.closeQuietly((InputStream)fis);
                this.propFileTimestamp = this.propFile.lastModified();
                break block8;
            }
            this.propFileTimestamp = -1L;
        }
        this.properties = properties;
        try {
            this.propFileScanInterval = Integer.parseInt(properties.getProperty("config.scan.interval")) * 1000;
        }
        catch (NumberFormatException e) {
            this.propFileScanInterval = 60000L;
        }
        this.log.debug("Scan interval for health check configuration: {} ms", (Object)this.propFileScanInterval);
    }

    private synchronized void saveProperties() {
        this.log.debug("Saving health check configuration to {}", (Object)this.propFile);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.propFile);
            this.properties.store(fos, "Configuration for Health Check");
        }
        catch (IOException e) {
            try {
                this.log.error("Unable to save health check configuration to {}", (Object)this.propFile, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        this.propFileTimestamp = this.propFile.lastModified();
    }

    private synchronized void syncProperties(boolean forceSync) {
        if (forceSync || this.propFileScanInterval >= 0L && System.currentTimeMillis() - this.propFileLastScan > this.propFileScanInterval) {
            this.propFileLastScan = System.currentTimeMillis();
            if (this.propFile.lastModified() != this.propFileTimestamp) {
                this.loadProperties();
            }
        }
    }
}

