/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.plugins.healthcheck.HealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.internal.capability.HealthCheckCapability;
import com.sonatype.nexus.plugins.healthcheck.internal.capability.HealthCheckCapabilityDescriptor;
import com.sonatype.nexus.plugins.healthcheck.rest.HealthCheckStatusHook;
import com.sonatype.nexus.plugins.healthcheck.rest.RestUrlBuilder;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.RepositoryHealthCheckStatusDTO;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.RepositoryHealthCheckStatusListDTO;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckTask;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.common.error.WebApplicationMessageException;

@Named(value="HealthCheckStatusResource")
@Singleton
@Path(value="/healthcheck/healthCheckStatus")
public class HealthCheckStatusResource
extends ComponentSupport
implements Resource {
    public static final String URI = "/healthcheck/healthCheckStatus";
    public static final String CURRENT_REPORT = "current";
    private final RepositoryRegistry repoRegistry;
    private final ConfigService config;
    private final HealthCheckTaskManager taskManager;
    private final WebServerManager webManager;
    private final List<HealthCheckStatusHook> statusHooks;
    private final EulaService eula;
    private final LicenseService license;
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public HealthCheckStatusResource(RepositoryRegistry repoRegistry, ConfigService config, HealthCheckTaskManager taskManager, WebServerManager webManager, List<HealthCheckStatusHook> statusHooks, EulaService eula, LicenseService license, CapabilityRegistry capabilityRegistry) {
        this.repoRegistry = repoRegistry;
        this.config = config;
        this.taskManager = taskManager;
        this.webManager = webManager;
        this.statusHooks = statusHooks;
        this.eula = eula;
        this.license = license;
        this.capabilityRegistry = capabilityRegistry;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:healthcheck:read"})
    public RepositoryHealthCheckStatusListDTO list() {
        this.log.debug("Getting repository health check status");
        RestUrlBuilder urlBuilder = new RestUrlBuilder();
        boolean detailedReportSupported = this.license.isDetailedReportSupported();
        List proxyRepos = this.repoRegistry.getRepositoriesWithFacet(ProxyRepository.class);
        RepositoryHealthCheckStatusListDTO dto = new RepositoryHealthCheckStatusListDTO();
        dto.setEulaAccepted(this.isEulaAccepted(null));
        dto.setConfiguredForNewRepositories(this.taskManager.isConfiguredForNewRepositories());
        for (ProxyRepository proxyRepo : proxyRepos) {
            if (!HealthCheckTask.isSupported((Repository)proxyRepo)) continue;
            dto.addRepository(this.buildDTO(proxyRepo, urlBuilder, detailedReportSupported));
        }
        return dto;
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:healthcheck:update"})
    public RepositoryHealthCheckStatusListDTO enableForAll(@QueryParam(value="eulaAccepted") String eulaAccepted) throws Exception {
        this.log.debug("Enabling repository health check for all supported repositories");
        this.validateEulaAcceptance(eulaAccepted);
        this.enableHealthCheckCapability();
        return this.list();
    }

    private void enableHealthCheckCapability() throws InvalidConfigurationException, IOException {
        Map<String, String> capabilityProperties = new HealthCheckConfiguration(true).toProperties();
        CapabilityIdentity capabilityIdentity = this.findHealthCheckCapability();
        if (capabilityIdentity == null) {
            this.capabilityRegistry.add(HealthCheckCapabilityDescriptor.TYPE, true, null, capabilityProperties);
        } else {
            this.capabilityRegistry.update(capabilityIdentity, true, null, capabilityProperties);
            this.taskManager.configure(true, true);
        }
    }

    private CapabilityIdentity findHealthCheckCapability() {
        for (CapabilityReference capabilityReference : this.capabilityRegistry.getAll()) {
            if (!(capabilityReference.capability() instanceof HealthCheckCapability)) continue;
            return capabilityReference.context().id();
        }
        return null;
    }

    @GET
    @Path(value="{repositoryId}")
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:healthcheck:read"})
    public RepositoryHealthCheckStatusDTO get(final @PathParam(value="repositoryId") String repositoryId) {
        this.log.debug("Getting repository health check status");
        RestUrlBuilder urlBuilder = new RestUrlBuilder();
        boolean detailedReportSupported = this.license.isDetailedReportSupported();
        ProxyRepository proxyRepo = (ProxyRepository)Iterables.find((Iterable)this.repoRegistry.getRepositoriesWithFacet(ProxyRepository.class), (Predicate)new Predicate<ProxyRepository>(){

            public boolean apply(@Nullable ProxyRepository proxyRepository) {
                return proxyRepository.getId().equals(repositoryId);
            }
        });
        return this.buildDTO(proxyRepo, urlBuilder, detailedReportSupported);
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:healthcheck:update"})
    public RepositoryHealthCheckStatusDTO put(@QueryParam(value="eulaAccepted") String eulaAccepted, RepositoryHealthCheckStatusDTO dto) {
        boolean enabled = "enabled".equals(dto.getStatus());
        if (enabled) {
            this.validateEulaAcceptance(eulaAccepted);
            this.taskManager.scheduleTask(dto.getId());
        } else {
            this.taskManager.stopTask(dto.getId());
        }
        this.config.setEnabled(dto.getId(), enabled);
        return dto;
    }

    private RepositoryHealthCheckStatusDTO buildDTO(ProxyRepository proxyRepo, RestUrlBuilder urlBuilder, boolean detailedReportSupported) {
        RepositoryHealthCheckStatusDTO dto = new RepositoryHealthCheckStatusDTO();
        dto.setId(proxyRepo.getId());
        dto.setDetailedReportSupported(detailedReportSupported);
        WebServerService webService = this.webManager.getWebServer(proxyRepo.getId());
        Properties reportProps = null;
        if (webService != null) {
            reportProps = webService.getBundleProperties();
            dto.setIframeHeight(Integer.valueOf(reportProps.getProperty("height", "480")).intValue());
            dto.setIframeWidth(Integer.valueOf(reportProps.getProperty("width", "640")).intValue());
            dto.setSecurityIssueCount(Integer.valueOf(reportProps.getProperty("issues.security", "0")).intValue());
            dto.setLicenseIssueCount(Integer.valueOf(reportProps.getProperty("issues.license", "0")).intValue());
            dto.setHealthCheckSummaryUrl(urlBuilder.buildUrl("/healthcheck/healthCheckSummary/{repositoryId}/{path:.*}", proxyRepo.getId(), "summary.html"));
        }
        if (!this.config.isEnabled(proxyRepo.getId())) {
            dto.setStatus("disabled");
        } else if (this.taskManager.getTask(proxyRepo.getId()) == null) {
            dto.setStatus("disabled");
            this.config.setEnabled(proxyRepo.getId(), false);
        } else if (webService == null || !webService.bundleExists()) {
            dto.setStatus("analyzing");
        } else {
            dto.setStatus("enabled");
        }
        for (HealthCheckStatusHook statusHook : this.statusHooks) {
            statusHook.updateStatus(dto, urlBuilder, (Repository)proxyRepo, reportProps);
        }
        return dto;
    }

    private void validateEulaAcceptance(String eulaAccepted) {
        if (!this.isEulaAccepted(eulaAccepted)) {
            throw new WebApplicationMessageException(Response.Status.CONFLICT, "The End User License Agreement must be accepted before utilizing Repository Health Check functionality");
        }
    }

    private boolean isEulaAccepted(String eulaAccepted) {
        if (this.eula.isEulaAccepted()) {
            return true;
        }
        if (eulaAccepted != null && eulaAccepted.equalsIgnoreCase("true")) {
            this.eula.acceptEula();
            return true;
        }
        return false;
    }
}

