/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.sonatype.nexus.plugins.healthcheck.rest.dto.RepositoryHealthCheckInfoDTO;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/healthcheck/healthCheckInfo")
public class HealthCheckInfoResource
extends ComponentSupport
implements Resource {
    public static final String URI = "/healthcheck/healthCheckInfo";
    private final NexusIDService nexusId;
    private final SecurityService security;

    @Inject
    public HealthCheckInfoResource(NexusIDService nexusId, SecurityService security) {
        this.nexusId = nexusId;
        this.security = security;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:pluginconsoleplugininfos:read"})
    public RepositoryHealthCheckInfoDTO get(@Context HttpServletRequest request) {
        this.log.debug("Getting repository health check plugin information");
        this.security.blockAnonymousUser(request);
        RepositoryHealthCheckInfoDTO dto = new RepositoryHealthCheckInfoDTO();
        dto.setNexusId(this.nexusId.getNexusID());
        return dto;
    }
}

