/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.sonatype.nexus.plugins.healthcheck.rest.dto.EulaStatusDTO;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/healthcheck/healthCheckEula")
public class HealthCheckEulaResource
implements Resource {
    public static final String URI = "/healthcheck/healthCheckEula";
    private final EulaService eula;

    @Inject
    public HealthCheckEulaResource(EulaService eula) {
        this.eula = eula;
    }

    @POST
    @RequiresPermissions(value={"nexus:healthcheck:create"})
    public void post(@QueryParam(value="eulaAccepted") String eulaAccepted) {
        if (Boolean.valueOf(eulaAccepted).booleanValue()) {
            this.eula.acceptEula();
        } else {
            this.eula.clearEula();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"nexus:healthcheck:read"})
    public EulaStatusDTO get() {
        return new EulaStatusDTO().withAccepted(this.eula.isEulaAccepted());
    }
}

