/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.sonatype.nexus.plugins.healthcheck.rest.AbstractSearchExtrasResource;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.GAVDetailListDTO;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.InsightService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/healthcheck/gavDetails")
public class GAVDetailsResource
extends AbstractSearchExtrasResource<GAVDetailListDTO>
implements Resource {
    public static final String URI = "/healthcheck/gavDetails";
    private final InsightService insight;

    @Inject
    public GAVDetailsResource(InsightService insight, ConfigService config, RepositoryRegistry repoRegistry) {
        super(config, repoRegistry);
        this.insight = insight;
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public GAVDetailListDTO populateRhcData(GAVDetailListDTO gavList) {
        return this.doPut(gavList);
    }

    @Override
    protected HttpResult getResponse(GAVDetailListDTO dto) throws IOException {
        return this.insight.getGAVExtras(dto, false);
    }

    @Override
    protected GAVDetailListDTO convertResponse(HttpResult result) throws IOException {
        return this.insight.convertGAVExtras(result);
    }
}

