/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckTask;
import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractSearchExtrasResource<T>
extends ComponentSupport {
    private final RepositoryRegistry repoRegistry;
    private final ConfigService config;

    public AbstractSearchExtrasResource(ConfigService config, RepositoryRegistry repoRegistry) {
        this.config = config;
        this.repoRegistry = repoRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T doPut(T payload) {
        if (!this.isHealthCheckEnabled()) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        try (HttpResult result = this.getResponse(payload);){
            if (result.isSuccess()) {
                T t = this.convertResponse(result);
                return t;
            }
            if (result.getStatusCode() == Response.Status.CONFLICT.getStatusCode()) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            this.log.error("Could not contact Sonatype server, error code {}", (Object)result.getStatusCode());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            this.log.error("Could not contact Sonatype server", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isHealthCheckEnabled() {
        for (Repository repo : this.repoRegistry.getRepositories()) {
            if (!this.config.isEnabled(repo.getId()) || !HealthCheckTask.isSupported(repo)) continue;
            return true;
        }
        return false;
    }

    protected abstract HttpResult getResponse(T var1) throws IOException;

    protected abstract T convertResponse(HttpResult var1) throws IOException;
}

