/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.rest;

import com.sonatype.nexus.plugins.healthcheck.rest.RestUrlBuilder;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.sisu.siesta.common.error.WebApplicationMessageException;

public abstract class AbstractHealthCheckWebContentResource {
    public static final String CURRENT_REPORT = "current";
    private final WebServerManager webServerManager;

    public AbstractHealthCheckWebContentResource(WebServerManager webServerManager) {
        this.webServerManager = webServerManager;
    }

    protected Response doGet(String uri, String repositoryId, String path, HttpServletRequest request, HttpServletResponse response) {
        this.preGet(request);
        try {
            String redirectPath = this.getRedirectPath(uri, path, repositoryId);
            if (redirectPath != null) {
                response.sendRedirect(redirectPath);
                return null;
            }
            if (path == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            path = path.substring(path.indexOf("/") + 1);
            WebServerService webServer = this.webServerManager.getWebServer(repositoryId);
            if (webServer == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            WebServerService.ContentItem content = webServer.getContentItem(this.getBaseDirectory() + "/" + path);
            if (content == null || !content.exists()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return Response.ok((Object)new FileInputStream(content.getFile()), (String)content.getMediaType()).expires(new Date(System.currentTimeMillis() + 29030400L)).lastModified(new Date(content.getFile().lastModified())).build();
        }
        catch (IOException e) {
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "Unable to process requested content.");
        }
    }

    protected boolean preGet(HttpServletRequest request) {
        return true;
    }

    private String getRedirectPath(String uri, String path, String repositoryId) {
        if (!path.startsWith("current/")) {
            return null;
        }
        String timestamp = "unknown";
        WebServerService webService = this.webServerManager.getWebServer(repositoryId);
        if (webService != null) {
            Properties reportProps = webService.getBundleProperties();
            timestamp = reportProps.getProperty("timestamp", timestamp);
        }
        return new RestUrlBuilder().buildUrl(uri, repositoryId, path, timestamp);
    }

    protected abstract String getBaseDirectory();
}

