/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.internal.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Named(value="healthcheck")
@Singleton
public class HealthCheckCapabilityDescriptor
extends CapabilityDescriptorSupport
implements Taggable {
    public static final String TYPE_ID = "healthcheck";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"healthcheck");
    private final EulaService eulaService;
    private List<FormField> formFields;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public HealthCheckCapabilityDescriptor(EulaService eulaService) {
        this.eulaService = eulaService;
        this.formFields = Lists.newArrayList((Object[])new FormField[]{new CheckboxFormField("configuredForAll", messages.configureForAllLabel(), messages.configureForAllHelp(), false).withInitialValue(Boolean.valueOf(true))});
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Health Check")});
    }

    protected String renderAbout() throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("eulaAccepted", this.eulaService.isEulaAccepted() ? "You have previously accepted these terms." : "Please read the TOS as you have not yet accepted these terms.");
        return this.render("healthcheck-about.vm", params);
    }

    public Validator validator() {
        return this.validators().capability().uniquePer(TYPE, new String[0]);
    }

    public Validator validator(CapabilityIdentity id) {
        return this.validators().capability().uniquePerExcluding(id, TYPE, new String[0]);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Health Check: Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="Configure for all proxy repositories")
        public String configureForAllLabel();

        @MessageBundle.DefaultMessage(value="Configure all supported proxy repositories to regularly check with RHC for updates by default. Newly added repositories will automatically be configured as well, for as long as this is selected.")
        public String configureForAllHelp();
    }
}

