/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.internal.capability;

import com.sonatype.nexus.plugins.healthcheck.HealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.support.CapabilitySupport;

@Named(value="healthcheck")
public class HealthCheckCapability
extends CapabilitySupport<HealthCheckConfiguration> {
    private final HealthCheckTaskManager healthCheckTaskManager;
    private final EulaService eulaService;

    @Inject
    public HealthCheckCapability(HealthCheckTaskManager healthCheckTaskManager, EulaService eulaService) {
        this.healthCheckTaskManager = healthCheckTaskManager;
        this.eulaService = eulaService;
    }

    protected HealthCheckConfiguration createConfig(Map<String, String> properties) {
        return new HealthCheckConfiguration(properties);
    }

    protected void onUpdate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), false);
    }

    protected void onActivate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), false);
    }

    public void onCreate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), config.isConfiguredForAll());
        if (!this.eulaService.isEulaAccepted()) {
            this.eulaService.acceptEula();
        }
    }

    protected void onRemove(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(false, false);
    }

    protected String renderStatus() throws Exception {
        return this.decideStatus();
    }

    protected String renderDescription() throws Exception {
        return this.decideStatus();
    }

    private String decideStatus() {
        return "Configured for all supported repositories: " + ((HealthCheckConfiguration)((Object)this.getConfig())).isConfiguredForAll();
    }
}

