/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.capability.support.CapabilityConfigurationSupport;

public class HealthCheckConfiguration
extends CapabilityConfigurationSupport {
    @NonNls
    public static final String CONFIGURED_FOR_ALL = "configuredForAll";
    private boolean configuredForAll;

    public HealthCheckConfiguration() {
    }

    public HealthCheckConfiguration(boolean configuredForAll) {
        this.configuredForAll = configuredForAll;
    }

    public HealthCheckConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.configuredForAll = this.parseBoolean(properties.get(CONFIGURED_FOR_ALL), false);
    }

    public boolean isConfiguredForAll() {
        return this.configuredForAll;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "configuredForAll=" + this.configuredForAll + '}';
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CONFIGURED_FOR_ALL, Boolean.toString(this.isConfiguredForAll()));
        return properties;
    }
}

