/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.jacksbee.runtime;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@XStreamAlias(value="unique-list")
public class UniqueList<E>
extends AbstractList<E> {
    @XStreamImplicit
    private final List<E> delegate;
    @XStreamOmitField
    private Set<E> unique = new LinkedHashSet();

    public UniqueList(List<E> delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
    }

    public UniqueList() {
        this(new ArrayList());
    }

    public static <T> UniqueList<T> create() {
        return new UniqueList();
    }

    public static <T> UniqueList<T> create(Iterable<? extends T> elements) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T element : elements) {
            tmp.add(element);
        }
        return new UniqueList(tmp);
    }

    private Object readResolve() {
        if (this.delegate == null) {
            return null;
        }
        this.unique = new LinkedHashSet();
        Iterator<E> iter = this.delegate.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (this.unique.contains(element)) {
                iter.remove();
                continue;
            }
            this.unique.add(element);
        }
        return this;
    }

    @Override
    public boolean contains(Object obj) {
        return this.unique.contains(obj);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public E set(int index, E element) {
        if (!this.contains(element)) {
            this.unique.add(element);
            return this.delegate.set(index, element);
        }
        return null;
    }

    @Override
    public void add(int index, E element) {
        if (!this.contains(element)) {
            this.unique.add(element);
            this.delegate.add(index, element);
        }
    }

    @Override
    public E remove(int index) {
        E obj = this.delegate.remove(index);
        this.unique.remove(obj);
        return obj;
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.delegate).equals(obj);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

