/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling.schedules;

import java.util.Date;
import java.util.Set;
import org.sonatype.scheduling.iterators.SchedulerIterator;
import org.sonatype.scheduling.iterators.WeeklySchedulerIterator;
import org.sonatype.scheduling.schedules.AbstractSchedule;

public class WeeklySchedule
extends AbstractSchedule {
    private final Set<Integer> daysToRun;

    public WeeklySchedule(Date startDate, Date endDate, Set<Integer> daysToRun) {
        super(startDate, endDate);
        this.daysToRun = daysToRun;
    }

    public Set<Integer> getDaysToRun() {
        return this.daysToRun;
    }

    @Override
    protected SchedulerIterator createIterator() {
        return new WeeklySchedulerIterator(this.getStartDate(), this.getEndDate(), this.daysToRun);
    }
}

