/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling.iterators;

import java.util.Date;
import java.util.Set;
import org.sonatype.scheduling.iterators.AbstractCalendarBasedSchedulerIterator;

public class WeeklySchedulerIterator
extends AbstractCalendarBasedSchedulerIterator {
    private final Set<Integer> weekdaysToRun;

    public WeeklySchedulerIterator(Date startingDate, Date endingDate, Set<Integer> weekdaysToRun) {
        super(startingDate, endingDate);
        this.weekdaysToRun = weekdaysToRun;
    }

    @Override
    public void stepNext() {
        if (this.weekdaysToRun == null || this.weekdaysToRun.isEmpty()) {
            this.getCalendar().add(3, 1);
        } else {
            this.getCalendar().add(7, 1);
            while (!this.weekdaysToRun.contains(this.getCalendar().get(7))) {
                this.getCalendar().add(7, 1);
            }
        }
    }
}

