/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling.iterators;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.sonatype.scheduling.iterators.AbstractCalendarBasedSchedulerIterator;

public class MonthlySchedulerIterator
extends AbstractCalendarBasedSchedulerIterator {
    public static final Integer LAST_DAY_OF_MONTH = new Integer(999);
    private final Set<Integer> monthdaysToRun;

    public MonthlySchedulerIterator(Date startingDate, Date endingDate, Set<Integer> monthdaysToRun) {
        super(startingDate, endingDate);
        this.monthdaysToRun = monthdaysToRun;
    }

    @Override
    public void stepNext() {
        if (this.monthdaysToRun == null || this.monthdaysToRun.isEmpty()) {
            this.getCalendar().add(2, 1);
        } else {
            this.getCalendar().add(5, 1);
            while (!this.monthdaysToRun.contains(this.getCalendar().get(5))) {
                if (this.monthdaysToRun.contains(LAST_DAY_OF_MONTH)) {
                    Calendar cal = (Calendar)this.getCalendar().clone();
                    cal.add(5, 1);
                    if (cal.get(5) == 1) break;
                }
                this.getCalendar().add(5, 1);
            }
        }
    }
}

