/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling.iterators;

import java.util.Date;
import org.sonatype.scheduling.iterators.AbstractSchedulerIterator;
import org.sonatype.scheduling.iterators.cron.CronExpression;

public class CronIterator
extends AbstractSchedulerIterator {
    private final CronExpression cronExpression;
    private Date nextDate;

    public CronIterator(CronExpression cronExpression) {
        super(new Date());
        this.cronExpression = cronExpression;
    }

    @Override
    protected Date doPeekNext() {
        if (this.nextDate == null) {
            this.nextDate = this.cronExpression.getNextValidTimeAfter(new Date());
        }
        return this.nextDate;
    }

    @Override
    protected void stepNext() {
        if (this.nextDate == null) {
            this.doPeekNext();
        } else {
            this.nextDate = this.cronExpression.getNextValidTimeAfter(this.doPeekNext());
        }
    }

    @Override
    public void resetFrom(Date from) {
        this.nextDate = this.cronExpression.getNextValidTimeAfter(from);
    }
}

