/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling.iterators;

import java.util.Date;
import org.sonatype.scheduling.iterators.SchedulerIterator;

public abstract class AbstractSchedulerIterator
implements SchedulerIterator {
    private final Date startingDate;
    private final Date endingDate;

    public AbstractSchedulerIterator(Date startingDate) {
        this(startingDate, null);
    }

    public AbstractSchedulerIterator(Date startingDate, Date endingDate) {
        if (startingDate == null) {
            throw new NullPointerException("Starting Date of " + this.getClass().getName() + " cannot be null!");
        }
        this.startingDate = startingDate;
        this.endingDate = endingDate;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    @Override
    public final Date peekNext() {
        Date current = this.doPeekNext();
        if (current == null || this.getEndingDate() != null && current.after(this.getEndingDate())) {
            return null;
        }
        return current;
    }

    @Override
    public final Date next() {
        Date result = this.peekNext();
        Date now = new Date();
        while (result != null && result.before(now)) {
            this.stepNext();
            result = this.peekNext();
        }
        this.stepNext();
        return result;
    }

    @Override
    public boolean isFinished() {
        return this.peekNext() == null;
    }

    protected abstract Date doPeekNext();

    protected abstract void stepNext();
}

