/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryImpl
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ThreadGroup schedulerThreadGroup;
    private final int threadPriority;

    public ThreadFactoryImpl() {
        this(1);
    }

    public ThreadFactoryImpl(int threadPriority) {
        int poolNum = poolNumber.getAndIncrement();
        this.schedulerThreadGroup = new ThreadGroup("Sisu scheduler #" + poolNum);
        this.namePrefix = "pxpool-" + poolNum + "-thread-";
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread result = new Thread(this.getSchedulerThreadGroup(), r, this.namePrefix + this.threadNumber.getAndIncrement());
        result.setDaemon(false);
        result.setPriority(this.threadPriority);
        return result;
    }

    public ThreadGroup getSchedulerThreadGroup() {
        return this.schedulerThreadGroup;
    }
}

