/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import org.sonatype.scheduling.CancellableProgressListenerWrapper;
import org.sonatype.scheduling.ProgressListener;
import org.sonatype.scheduling.ProgressListenerWrapper;
import org.sonatype.scheduling.TaskInterruptedException;

public class TaskUtil {
    private static final ThreadLocal<ProgressListener> CURRENT = new ThreadLocal<ProgressListener>(){

        @Override
        protected ProgressListener initialValue() {
            return new ProgressListenerWrapper(null);
        }
    };

    protected static void setCurrent(ProgressListener progressListener) {
        if (progressListener != null) {
            CURRENT.set(new CancellableProgressListenerWrapper(progressListener));
        } else {
            CURRENT.set(new ProgressListenerWrapper(null));
        }
    }

    public static ProgressListener getCurrentProgressListener() {
        return CURRENT.get();
    }

    public static void checkInterruption() throws TaskInterruptedException {
        Thread.yield();
        if (TaskUtil.getCurrentProgressListener().isCanceled()) {
            throw new TaskInterruptedException("Thread \"" + Thread.currentThread().getName() + "\" is canceled!", true);
        }
        if (Thread.interrupted()) {
            throw new TaskInterruptedException("Thread \"" + Thread.currentThread().getName() + "\" is interrupted!", false);
        }
    }
}

