/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import org.sonatype.scheduling.ProgressListener;
import org.sonatype.scheduling.TaskUtil;

public class ProgressListenerWrapper
implements ProgressListener {
    private final ProgressListener wrapped;

    public ProgressListenerWrapper(ProgressListener wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void beginTask(String name) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.beginTask(name);
        }
    }

    @Override
    public void beginTask(String name, int toDo) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.beginTask(name, toDo);
        }
    }

    @Override
    public void working(int workDone) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.working(workDone);
        }
    }

    @Override
    public void working(String message) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.working(message);
        }
    }

    @Override
    public void working(String message, int work) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.working(message, work);
        }
    }

    @Override
    public void endTask(String message) {
        TaskUtil.checkInterruption();
        if (this.wrapped != null) {
            this.wrapped.endTask(message);
        }
    }

    @Override
    public boolean isCanceled() {
        if (this.wrapped != null) {
            return this.wrapped.isCanceled();
        }
        return false;
    }

    @Override
    public void cancel() {
        if (this.wrapped != null) {
            this.wrapped.cancel();
        }
    }
}

