/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.scheduling.ProgressListener;

public class LoggingProgressListener
implements ProgressListener {
    private static final Workunit ROOT = new Workunit("root", -1);
    private final Logger logger;
    private final Deque<Workunit> workunits;
    private volatile boolean canceled = false;

    public LoggingProgressListener(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    public LoggingProgressListener(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        this.logger = logger;
        this.workunits = new ArrayDeque<Workunit>(Arrays.asList(ROOT));
        this.canceled = false;
    }

    @Override
    public void beginTask(String name) {
        this.beginTask(name, -1);
    }

    @Override
    public void beginTask(String name, int toDo) {
        this.workunits.push(new Workunit(name, toDo));
        if (this.logger.isInfoEnabled()) {
            if (-1 != toDo) {
                this.logger.info("{}: started ({} steps).", (Object)this.getStackedWorkunitNames(), (Object)toDo);
            } else {
                this.logger.info("{}: started.", (Object)this.getStackedWorkunitNames());
            }
        }
    }

    @Override
    public void working(int workDone) {
        this.working(null, workDone);
    }

    @Override
    public void working(String message) {
        this.working(message, 0);
    }

    @Override
    public void working(String message, int workDone) {
        Workunit wu = this.workunits.peek();
        wu.done(workDone);
        if (this.logger.isInfoEnabled() && message != null && message.trim().length() > 0) {
            if (-1 != wu.getToDo()) {
                this.logger.info("{}: {} ({}/{})", new Object[]{this.getStackedWorkunitNames(), message, wu.getDone(), wu.getToDo()});
            } else {
                this.logger.info("{}: {} ({})", new Object[]{this.getStackedWorkunitNames(), message, wu.getDone()});
            }
        }
    }

    @Override
    public void endTask(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}: finished: {}", (Object)this.getStackedWorkunitNames(), (Object)message);
        }
        if (this.workunits.size() > 1) {
            this.workunits.pop();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        String wus = this.getStackedWorkunitNames();
        if (this.logger.isDebugEnabled()) {
            if (wus != null && wus.trim().length() > 0) {
                this.logger.info("{}: canceled, bailing out (may take a while).", (Object)wus);
            } else {
                this.logger.info("Task canceled, bailing out (may take a while).");
            }
        }
        this.canceled = true;
    }

    protected String getStackedWorkunitNames() {
        Iterator<Workunit> wi = this.workunits.descendingIterator();
        wi.next();
        if (wi.hasNext()) {
            StringBuilder sb = new StringBuilder(wi.next().getName());
            while (wi.hasNext()) {
                sb.append(" - ").append(wi.next().getName());
            }
            return sb.toString();
        }
        return "";
    }

    public static class Workunit {
        private final String name;
        private final int toDo;
        private int done;

        public Workunit(String name, int toDo) {
            this.name = name;
            this.toDo = toDo;
            this.done = 0;
        }

        public String getName() {
            return this.name;
        }

        public int getToDo() {
            return this.toDo;
        }

        public int getDone() {
            return this.done;
        }

        public void done(int done) {
            this.done += done;
        }
    }
}

