/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.scheduling.DefaultScheduledTask;
import org.sonatype.scheduling.NoSuchTaskException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.Scheduler;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskConfigManager;
import org.sonatype.scheduling.TaskExecutorProvider;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.ThreadFactoryImpl;
import org.sonatype.scheduling.schedules.RunNowSchedule;
import org.sonatype.scheduling.schedules.Schedule;

@Named
@Singleton
public class DefaultScheduler
implements Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScheduler.class);
    private final TaskConfigManager taskConfig;
    private final AtomicInteger idGen;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentHashMap<String, List<ScheduledTask<?>>> tasksMap;

    @Deprecated
    public DefaultScheduler(TaskConfigManager taskConfig) {
        this(taskConfig, new TaskExecutorProvider(){

            @Override
            public ScheduledExecutorService getTaskExecutor() {
                ScheduledThreadPoolExecutor scheduledExecutorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(20, new ThreadFactoryImpl(1));
                scheduledExecutorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                scheduledExecutorService.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                return scheduledExecutorService;
            }
        });
    }

    @Inject
    public DefaultScheduler(TaskConfigManager taskConfig, TaskExecutorProvider scheduledExecutorServiceProvider) {
        this.taskConfig = taskConfig;
        this.scheduledExecutorService = scheduledExecutorServiceProvider.getTaskExecutor();
        this.idGen = new AtomicInteger(0);
        this.tasksMap = new ConcurrentHashMap();
    }

    protected Logger getLogger() {
        return logger;
    }

    @Override
    public void initializeTasks() {
        this.getLogger().info("Initializing Scheduler...");
        this.taskConfig.initializeTasks(this);
        int maxId = 0;
        for (Map.Entry<String, List<ScheduledTask<?>>> entry : this.getAllTasks().entrySet()) {
            for (ScheduledTask<?> task : entry.getValue()) {
                try {
                    maxId = Math.max(maxId, Integer.parseInt(task.getId()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.idGen.set(maxId);
    }

    @Override
    public void shutdown() {
        this.getLogger().info("Shutting down Scheduler...");
        try {
            this.scheduledExecutorService.shutdown();
            boolean stopped = this.scheduledExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
            if (!stopped) {
                Map<String, List<ScheduledTask<?>>> runningTasks = this.getRunningTasks();
                if (!runningTasks.isEmpty()) {
                    this.scheduledExecutorService.shutdownNow();
                    this.getLogger().warn("Scheduler shut down forcibly with tasks running.");
                } else {
                    this.getLogger().info("Scheduler shut down cleanly with tasks scheduled.");
                }
            }
        }
        catch (InterruptedException e) {
            this.getLogger().info("Termination interrupted", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public SchedulerTask<?> createTaskInstance(String taskType) throws IllegalArgumentException {
        return this.taskConfig.createTaskInstance(taskType);
    }

    @Override
    public <T> T createTaskInstance(Class<T> taskType) throws IllegalArgumentException {
        return this.taskConfig.createTaskInstance(taskType);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    protected <T> void addToTasksMap(ScheduledTask<T> task, boolean store) {
        this.tasksMap.putIfAbsent(task.getType(), new CopyOnWriteArrayList());
        this.tasksMap.get(task.getType()).add(task);
        if (store) {
            this.taskConfig.addTask(task);
        }
    }

    protected <T> void removeFromTasksMap(ScheduledTask<T> task) {
        List<ScheduledTask<?>> tasks = this.tasksMap.get(task.getType());
        if (tasks != null) {
            tasks.remove(task);
        }
        this.taskConfig.removeTask(task);
    }

    protected void taskRescheduled(ScheduledTask<?> task) {
        this.taskConfig.addTask(task);
    }

    protected String generateId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }

    @Override
    public <T> ScheduledTask<T> initialize(String id, String name, String type, Callable<T> callable, Schedule schedule, boolean enabled) {
        return this.schedule(id, name, type, callable, schedule, enabled, false);
    }

    @Override
    public ScheduledTask<Object> submit(String name, Runnable runnable) {
        return this.schedule(name, runnable, (Schedule)new RunNowSchedule());
    }

    @Override
    public ScheduledTask<Object> schedule(String name, Runnable runnable, Schedule schedule) {
        return this.schedule(name, runnable.getClass().getSimpleName(), Executors.callable(runnable), schedule);
    }

    @Override
    public <T> ScheduledTask<T> submit(String name, Callable<T> callable) {
        return this.schedule(name, callable, (Schedule)new RunNowSchedule());
    }

    @Override
    public <T> ScheduledTask<T> schedule(String name, Callable<T> callable, Schedule schedule) {
        return this.schedule(name, callable.getClass().getSimpleName(), callable, schedule);
    }

    protected <T> ScheduledTask<T> schedule(String name, String type, Callable<T> callable, Schedule schedule) {
        return this.schedule(this.generateId(), name, type, callable, schedule, true);
    }

    protected <T> ScheduledTask<T> schedule(String id, String name, String type, Callable<T> callable, Schedule schedule, boolean enabled, boolean store) {
        DefaultScheduledTask<T> dct = new DefaultScheduledTask<T>(id, name, type, this, callable, schedule);
        dct.setEnabled(enabled);
        this.addToTasksMap(dct, store);
        dct.start();
        return dct;
    }

    protected <T> ScheduledTask<T> schedule(String id, String name, String type, Callable<T> callable, Schedule schedule, boolean store) {
        return this.schedule(id, name, type, callable, schedule, true, store);
    }

    @Override
    public <T> ScheduledTask<T> updateSchedule(ScheduledTask<T> task) throws RejectedExecutionException, NullPointerException {
        this.taskConfig.addTask(task);
        return task;
    }

    @Override
    public Map<String, List<ScheduledTask<?>>> getAllTasks() {
        HashMap result = new HashMap(this.tasksMap.size());
        for (Map.Entry<String, List<ScheduledTask<?>>> entry : this.tasksMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return result;
    }

    private static boolean StringUtils_isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    @Override
    public ScheduledTask<?> getTaskById(String id) throws NoSuchTaskException {
        if (DefaultScheduler.StringUtils_isEmpty(id)) {
            throw new IllegalArgumentException("The Tasks cannot have null IDs!");
        }
        Collection<List<ScheduledTask<?>>> activeTasks = this.getAllTasks().values();
        for (List<ScheduledTask<?>> tasks : activeTasks) {
            for (ScheduledTask<?> task : tasks) {
                if (!task.getId().equals(id)) continue;
                return task;
            }
        }
        throw new NoSuchTaskException(id);
    }

    @Override
    public Map<String, List<ScheduledTask<?>>> getActiveTasks() {
        Map<String, List<ScheduledTask<?>>> result = this.getAllTasks();
        List<ScheduledTask<?>> tasks = null;
        Iterator<String> c = result.keySet().iterator();
        while (c.hasNext()) {
            String cls = c.next();
            tasks = result.get(cls);
            Iterator<ScheduledTask<?>> i = tasks.iterator();
            while (i.hasNext()) {
                ScheduledTask<?> task = i.next();
                if (task.getTaskState().isActiveOrSubmitted()) continue;
                i.remove();
            }
            if (!tasks.isEmpty()) continue;
            c.remove();
        }
        return result;
    }

    public Map<String, List<ScheduledTask<?>>> getRunningTasks() {
        Map<String, List<ScheduledTask<?>>> result = this.getAllTasks();
        List<ScheduledTask<?>> tasks = null;
        Iterator<String> c = result.keySet().iterator();
        while (c.hasNext()) {
            String cls = c.next();
            tasks = result.get(cls);
            Iterator<ScheduledTask<?>> i = tasks.iterator();
            while (i.hasNext()) {
                ScheduledTask<?> task = i.next();
                if (TaskState.RUNNING.equals((Object)task.getTaskState())) continue;
                i.remove();
            }
            if (!tasks.isEmpty()) continue;
            c.remove();
        }
        return result;
    }
}

