/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.sonatype.scheduling.DefaultScheduler;
import org.sonatype.scheduling.LoggingProgressListener;
import org.sonatype.scheduling.ProgressListener;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskExecutionException;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.scheduling.iterators.NoopSchedulerIterator;
import org.sonatype.scheduling.iterators.RunNowSchedulerIterator;
import org.sonatype.scheduling.iterators.SchedulerIterator;
import org.sonatype.scheduling.schedules.ManualRunSchedule;
import org.sonatype.scheduling.schedules.Schedule;
import org.sonatype.sisu.goodies.common.Loggers;

public class DefaultScheduledTask<T>
implements ScheduledTask<T>,
Callable<T> {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private final String id;
    private String name;
    private final String type;
    private final DefaultScheduler scheduler;
    private final Callable<T> callable;
    private TaskState taskState;
    private Date scheduledAt;
    private Future<T> future;
    private Throwable brokenCause;
    private boolean enabled;
    private Date lastRun;
    private Date nextRun;
    private List<T> results;
    private Schedule schedule;
    private SchedulerIterator scheduleIterator;
    private volatile ProgressListener progressListener;
    boolean manualRun;
    private long duration;
    private TaskState lastStatus;
    private boolean toBeRemoved = false;

    public DefaultScheduledTask(String id, String name, String type, DefaultScheduler scheduler, Callable<T> callable, Schedule schedule) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.scheduler = scheduler;
        this.callable = callable;
        this.taskState = TaskState.SUBMITTED;
        this.enabled = true;
        this.results = new ArrayList<T>();
        this.schedule = schedule;
        this.scheduleIterator = null;
        this.nextRun = null;
        this.manualRun = false;
    }

    @Override
    public SchedulerTask<T> getSchedulerTask() {
        Callable<T> task = this.getTask();
        if (task != null && task instanceof SchedulerTask) {
            return (SchedulerTask)task;
        }
        return null;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public Callable<T> getTask() {
        return this.callable;
    }

    protected void start() {
        this.scheduledAt = new Date();
        this.reschedule(true);
    }

    protected Future<T> getFuture() {
        return this.future;
    }

    protected void setFuture(Future<T> future) {
        this.future = future;
    }

    protected DefaultScheduler getScheduler() {
        return this.scheduler;
    }

    protected void setTaskState(TaskState state) {
        if (!this.getTaskState().isEndingState()) {
            this.taskState = state;
        }
    }

    protected void setBrokenCause(Throwable e) {
        this.brokenCause = e;
    }

    protected Callable<T> getCallable() {
        return this.callable;
    }

    protected boolean isManualRunScheduled() {
        return ManualRunSchedule.class.isAssignableFrom(this.getSchedule().getClass());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public TaskState getTaskState() {
        return this.taskState;
    }

    @Override
    public Date getScheduledAt() {
        return this.scheduledAt;
    }

    @Override
    public void cancelOnly() {
        this.cancel(false, this.getScheduleIterator().isFinished());
    }

    @Override
    public void cancel() {
        this.cancel(false);
    }

    @Override
    public void cancel(boolean interrupt) {
        this.cancel(interrupt, true);
    }

    public void cancel(boolean interrupt, boolean removeTask) {
        ProgressListener progressListener = this.getProgressListener();
        TaskState originalState = this.getTaskState();
        if (originalState.isExecuting() || originalState.equals((Object)TaskState.SLEEPING)) {
            this.setTaskState(TaskState.CANCELLING);
            if (progressListener != null) {
                progressListener.cancel();
            }
            if (this.getFuture() != null) {
                this.getFuture().cancel(interrupt);
            }
            if (originalState.equals((Object)TaskState.SLEEPING)) {
                this.setLastRun(new Date());
                if (this.getScheduleIterator().isFinished()) {
                    removeTask = true;
                } else if (!removeTask) {
                    this.reschedule(true);
                    TaskState newState = this.isManualRunScheduled() ? TaskState.SUBMITTED : TaskState.WAITING;
                    this.setTaskState(newState);
                }
            }
            this.setToBeRemoved(removeTask);
        }
        if (removeTask && !originalState.isExecuting()) {
            this.setTaskState(TaskState.CANCELLED);
            this.getScheduler().removeFromTasksMap(this);
        }
    }

    @Override
    public void reset() {
        ProgressListener progressListener = this.getProgressListener();
        if (progressListener != null) {
            progressListener.cancel();
        }
        if (this.getFuture() != null) {
            this.getFuture().cancel(false);
        }
        this.setTaskState(TaskState.SUBMITTED);
        this.reschedule(true);
    }

    @Override
    public Throwable getBrokenCause() {
        return this.brokenCause;
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return this.getFuture().get();
    }

    @Override
    public T getIfDone() {
        if (TaskState.FINISHED.equals((Object)this.getTaskState())) {
            try {
                return this.getFuture().get();
            }
            catch (ExecutionException e) {
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    public void setLastRun(Date lastRun) {
        this.lastRun = new Date(lastRun.getTime() + 20L);
    }

    protected void setLastStatus(TaskState lastStatus) {
        this.lastStatus = lastStatus;
    }

    protected void setDuration(long duration) {
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<T> doSchedule(long nextTime, boolean inheritContext) {
        if (!inheritContext) {
            MDC.put((String)"non-inheritable", (String)"non-inheritable");
        }
        try {
            ScheduledFuture scheduledFuture = this.getScheduler().getScheduledExecutorService().schedule(this, Math.max(0L, nextTime - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
            return scheduledFuture;
        }
        finally {
            if (!inheritContext) {
                MDC.remove((String)"non-inheritable");
            }
        }
    }

    protected long reschedule(boolean setFuture) {
        if (!this.isManualRunScheduled()) {
            SchedulerIterator iter = this.getScheduleIterator();
            if (iter != null && !iter.isFinished()) {
                this.nextRun = iter.next();
                long nextTime = 0L;
                nextTime = this.nextRun != null ? this.nextRun.getTime() : System.currentTimeMillis();
                this.getScheduler().taskRescheduled(this);
                if (setFuture) {
                    this.setFuture(this.doSchedule(nextTime, iter instanceof RunNowSchedulerIterator));
                }
                return nextTime;
            }
            this.nextRun = null;
        } else {
            this.nextRun = null;
        }
        return -1L;
    }

    @Override
    public void runNow() {
        if (!TaskState.RUNNING.equals((Object)this.getTaskState()) && !this.manualRun) {
            this.manualRun = true;
            if (this.getFuture() != null) {
                this.getFuture().cancel(true);
            }
            this.setFuture(this.doSchedule(-1L, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        try {
            this.progressListener = new LoggingProgressListener(this.getCallable().getClass().getSimpleName());
            TaskUtil.setCurrent(this.progressListener);
            Object result = null;
            if (this.getCallable() instanceof SchedulerTask && !((SchedulerTask)this.getCallable()).allowConcurrentExecution(this.getScheduler().getActiveTasks())) {
                if (this.nextRun != null) {
                    this.nextRun = new Date(this.nextRun.getTime() + 10000L);
                }
                this.setFuture(this.getScheduler().getScheduledExecutorService().schedule(this, 10000L, TimeUnit.MILLISECONDS));
                this.setTaskState(TaskState.SLEEPING);
                Object e = result;
                return (T)e;
            }
            long nextMillis = -1L;
            Date peekBefore = null;
            Date peekAfter = null;
            if ((this.isEnabled() || this.manualRun) && this.getTaskState().isRunnable()) {
                this.setTaskState(TaskState.RUNNING);
                Date startDate = new Date();
                try {
                    if (!this.manualRun) {
                        nextMillis = this.reschedule(false);
                    } else if (this.nextRun != null) {
                        nextMillis = this.nextRun.getTime();
                    }
                    this.setLastRun(startDate);
                    peekBefore = this.getScheduleIterator().peekNext();
                    result = this.getCallable().call();
                    peekAfter = this.getScheduleIterator().peekNext();
                    if (result != null) {
                        this.results.add(result);
                    }
                    this.setLastStatus(TaskState.FINISHED);
                }
                catch (Throwable e) {
                    this.logger.warn("Exception in call method of scheduled task {}", (Object)this.getName(), (Object)e);
                    if (peekAfter == null) {
                        peekAfter = this.getScheduleIterator().peekNext();
                    }
                    this.setBrokenCause(e);
                    this.setLastStatus(TaskState.BROKEN);
                    if (this.isToBeRemoved()) {
                        this.setTaskState(TaskState.CANCELLED);
                    } else {
                        this.setTaskState(TaskState.BROKEN);
                    }
                    if (!this.isManualRunScheduled() && nextMillis == -1L && this.isEnabled() || this.isToBeRemoved()) {
                        this.getScheduler().removeFromTasksMap(this);
                    } else if (peekBefore == null && peekAfter != null || peekBefore != null && !peekBefore.equals(peekAfter)) {
                        this.reschedule(true);
                    } else if (nextMillis != -1L) {
                        this.setFuture(this.doSchedule(nextMillis, false));
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new TaskExecutionException(e);
                }
                finally {
                    this.setDuration(System.currentTimeMillis() - startDate.getTime());
                }
            }
            if (TaskState.BROKEN != this.getTaskState()) {
                if (this.isToBeRemoved()) {
                    this.setTaskState(TaskState.CANCELLED);
                } else if (this.isManualRunScheduled()) {
                    this.setTaskState(TaskState.SUBMITTED);
                } else if (peekBefore == null && peekAfter != null || peekBefore != null && !peekBefore.equals(peekAfter)) {
                    this.setTaskState(TaskState.WAITING);
                    this.reschedule(true);
                } else if (nextMillis != -1L) {
                    this.setTaskState(TaskState.WAITING);
                    this.setFuture(this.doSchedule(nextMillis, false));
                } else if (!this.isEnabled()) {
                    this.setTaskState(TaskState.WAITING);
                    this.reschedule(true);
                } else if (TaskState.CANCELLING.equals((Object)this.getTaskState())) {
                    this.setTaskState(TaskState.CANCELLED);
                } else {
                    this.setTaskState(TaskState.FINISHED);
                }
            }
            if (this.getTaskState().isEndingState()) {
                this.getScheduler().removeFromTasksMap(this);
            }
            Object e = result;
            return (T)e;
        }
        finally {
            this.manualRun = false;
            this.progressListener = null;
            TaskUtil.setCurrent(null);
        }
    }

    @Override
    public Date getLastRun() {
        return this.lastRun;
    }

    @Override
    public TaskState getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public Date getNextRun() {
        return this.nextRun;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }

    @Override
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.scheduleIterator = null;
    }

    @Override
    public SchedulerIterator getScheduleIterator() {
        if (this.scheduleIterator == null && this.getSchedule() != null) {
            this.scheduleIterator = this.getSchedule().getIterator();
        }
        if (this.scheduleIterator == null) {
            return new NoopSchedulerIterator();
        }
        return this.scheduleIterator;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getTaskParams() {
        if (SchedulerTask.class.isAssignableFrom(this.getCallable().getClass())) {
            return ((SchedulerTask)this.getCallable()).getParameters();
        }
        return Collections.emptyMap();
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public void setToBeRemoved(boolean toBeRemoved) {
        this.toBeRemoved = toBeRemoved;
    }
}

