/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.scheduling;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskInterruptedException;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.Loggers;

public abstract class AbstractSchedulerTask<T>
implements SchedulerTask<T> {
    protected Logger logger = Loggers.getLogger(this.getClass());
    private Map<String, String> parameters;

    @Override
    public void addParameter(String key, String value) {
        this.getParameters().put(key, value);
    }

    @Override
    public String getParameter(String key) {
        return this.getParameters().get(key);
    }

    @Override
    public synchronized Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    @Override
    public abstract T call() throws Exception;

    protected Logger getLogger() {
        return this.logger;
    }

    protected void checkInterruption() throws TaskInterruptedException {
        TaskUtil.checkInterruption();
    }
}

