/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mac;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class MacPluginEventSubscriber
extends ComponentSupport
implements EventSubscriber {
    private static final String ARCHETYPE_PATH = "/archetype-catalog.xml";
    private final ContentClass maven2ContentClass;

    @Inject
    public MacPluginEventSubscriber(@Named(value="maven2") ContentClass maven2ContentClass) {
        this.maven2ContentClass = (ContentClass)Preconditions.checkNotNull((Object)maven2ContentClass);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryEventAdd evt) {
        Repository repository = evt.getRepository();
        if (this.isArchetypeCatalogSubject(repository)) {
            this.manageArchetypeCatalog(repository);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryConfigurationUpdatedEvent evt) {
        Repository repository = evt.getRepository();
        if (this.isArchetypeCatalogSubject(repository)) {
            this.manageArchetypeCatalog(repository);
        }
    }

    private boolean isArchetypeCatalogSubject(Repository repository) {
        return this.maven2ContentClass.isCompatible(repository.getRepositoryContentClass()) && repository.getLocalStatus().shouldServiceRequest() && (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class) || repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class) || repository.getRepositoryKind().isFacetAvailable(GroupRepository.class));
    }

    private void manageArchetypeCatalog(Repository repository) {
        block11: {
            if (repository.isIndexable()) {
                try {
                    DefaultStorageFileItem file = new DefaultStorageFileItem(repository, new ResourceStoreRequest(ARCHETYPE_PATH), true, false, (ContentLocator)new StringContentLocator("ArchetypeContentGenerator"));
                    file.setContentGeneratorId("ArchetypeContentGenerator");
                    repository.storeItem(false, (StorageItem)file);
                }
                catch (RepositoryNotAvailableException e) {
                    this.log.info("Unable to install the generated archetype catalog, repository {} is out of service", (Object)e.getRepository().getId());
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.info("Unable to install the generated archetype catalog in repository {}:", (Object)repository, (Object)e);
                        break block11;
                    }
                    this.log.info("Unable to install the generated archetype catalog in repository {}: {}/{}", new Object[]{repository, e.getClass(), e.getMessage()});
                }
            } else {
                try {
                    repository.deleteItem(false, new ResourceStoreRequest(ARCHETYPE_PATH));
                }
                catch (RepositoryNotAvailableException e) {
                    this.log.info("Unable to uninstall the generated archetype catalog, repository {} is out of service", (Object)e.getRepository().getId());
                }
                catch (ItemNotFoundException e) {
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.info("Unable to uninstall the generated archetype catalog in repository {}:", (Object)repository, (Object)e);
                    }
                    this.log.info("Unable to uninstall the generated archetype catalog in repository {}: {}/{}", new Object[]{repository, e.getClass(), e.getMessage()});
                }
            }
        }
    }
}

