/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mac;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.index.AndMultiArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.sonatype.nexus.plugins.mac.MacPlugin;
import org.sonatype.nexus.plugins.mac.MacRequest;

@Singleton
@Named
public class DefaultMacPlugin
implements MacPlugin {
    private final NexusIndexer indexer;

    @Inject
    public DefaultMacPlugin(NexusIndexer indexer) {
        this.indexer = (NexusIndexer)Preconditions.checkNotNull((Object)indexer);
    }

    protected IteratorSearchResponse listArchetypes(MacRequest request, IndexingContext ctx) throws IOException {
        Query pq = this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("maven-archetype"));
        if (ctx == null) {
            return IteratorSearchResponse.empty((Query)pq);
        }
        IteratorSearchRequest sreq = new IteratorSearchRequest(pq, ctx);
        ClassifierArtifactInfoFilter classifierFilter = new ClassifierArtifactInfoFilter();
        if (request.getArtifactInfoFilter() != null) {
            AndMultiArtifactInfoFilter andArtifactFilter = new AndMultiArtifactInfoFilter(Arrays.asList(classifierFilter, request.getArtifactInfoFilter()));
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)andArtifactFilter);
        } else {
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)classifierFilter);
        }
        return this.indexer.searchIterator(sreq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchetypeCatalog listArcherypesAsCatalog(MacRequest request, IndexingContext ctx) throws IOException {
        try (IteratorSearchResponse infos = this.listArchetypes(request, ctx);){
            ArchetypeCatalog catalog = new ArchetypeCatalog();
            Archetype archetype = null;
            for (ArtifactInfo info : infos) {
                archetype = new Archetype();
                archetype.setGroupId(info.groupId);
                archetype.setArtifactId(info.artifactId);
                archetype.setVersion(info.version);
                archetype.setDescription(info.description);
                if (StringUtils.isNotEmpty((String)request.getRepositoryUrl())) {
                    archetype.setRepository(request.getRepositoryUrl());
                }
                catalog.addArchetype(archetype);
            }
            IteratorResultSet iteratorResultSet = catalog;
            return iteratorResultSet;
        }
    }

    public static class ClassifierArtifactInfoFilter
    implements ArtifactInfoFilter {
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return StringUtils.isBlank((String)ai.classifier);
        }
    }
}

