/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mac;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.context.IndexingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.DefaultIndexerManager;
import org.sonatype.nexus.plugins.mac.MacPlugin;
import org.sonatype.nexus.plugins.mac.MacRequest;
import org.sonatype.nexus.proxy.item.AbstractContentLocator;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class ArchetypeContentLocator
extends AbstractContentLocator {
    private static final Logger logger = LoggerFactory.getLogger(ArchetypeContentLocator.class);
    private final Repository repository;
    private final String repositoryContentUrl;
    private final DefaultIndexerManager nexusIndexer;
    private final MacPlugin macPlugin;
    private final ArtifactInfoFilter artifactInfoFilter;
    private volatile String payload;

    public ArchetypeContentLocator(Repository repository, String repositoryContentUrl, DefaultIndexerManager nexusIndexer, MacPlugin macPlugin, ArtifactInfoFilter artifactInfoFilter) {
        super("text/xml", true, -1L);
        this.repository = repository;
        this.repositoryContentUrl = repositoryContentUrl;
        this.nexusIndexer = nexusIndexer;
        this.macPlugin = macPlugin;
        this.artifactInfoFilter = artifactInfoFilter;
    }

    protected synchronized String generateCatalogPayload() throws IOException {
        if (this.payload == null) {
            this.nexusIndexer.shared(this.repository, new DefaultIndexerManager.Runnable(){

                public void run(IndexingContext context) throws IOException {
                    ArchetypeContentLocator.this.payload = ArchetypeContentLocator.this.generateCatalogPayload(context);
                }
            });
        }
        return this.payload;
    }

    private String generateCatalogPayload(IndexingContext context) throws IOException {
        MacRequest req = new MacRequest(this.repository.getId(), this.repositoryContentUrl, this.artifactInfoFilter);
        if (context == null) {
            logger.info("Archetype Catalog for repository {} is not buildable as it lacks IndexingContext (indexable=false?).", (Object)RepositoryStringUtils.getHumanizedNameString((Repository)this.repository));
        }
        ArchetypeCatalog catalog = this.macPlugin.listArcherypesAsCatalog(req, context);
        StringWriter sw = new StringWriter();
        ArchetypeCatalogXpp3Writer writer = new ArchetypeCatalogXpp3Writer();
        writer.write((Writer)sw, catalog);
        return sw.toString();
    }

    public InputStream getContent() throws IOException {
        String payload = this.generateCatalogPayload();
        if (payload != null) {
            return new ByteArrayInputStream(payload.getBytes("UTF-8"));
        }
        throw new IOException("Catalog could not be generated, no IndexingContext exists!");
    }
}

