/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mac;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.context.IndexingContext;
import org.sonatype.nexus.index.DefaultIndexerManager;
import org.sonatype.nexus.index.IndexArtifactFilter;
import org.sonatype.nexus.plugins.mac.ArchetypeContentLocator;
import org.sonatype.nexus.plugins.mac.MacPlugin;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.RepositoryURLBuilder;

@Named(value="ArchetypeContentGenerator")
@Singleton
public class ArchetypeContentGenerator
implements ContentGenerator {
    public static final String ID = "ArchetypeContentGenerator";
    private final MacPlugin macPlugin;
    private final DefaultIndexerManager indexerManager;
    private final IndexArtifactFilter indexArtifactFilter;
    private final RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public ArchetypeContentGenerator(MacPlugin macPlugin, DefaultIndexerManager indexerManager, IndexArtifactFilter indexArtifactFilter, RepositoryURLBuilder repositoryURLBuilder) {
        this.macPlugin = (MacPlugin)Preconditions.checkNotNull((Object)macPlugin);
        this.indexerManager = (DefaultIndexerManager)Preconditions.checkNotNull((Object)indexerManager);
        this.indexArtifactFilter = (IndexArtifactFilter)Preconditions.checkNotNull((Object)indexArtifactFilter);
        this.repositoryURLBuilder = (RepositoryURLBuilder)Preconditions.checkNotNull((Object)repositoryURLBuilder);
    }

    public String getGeneratorId() {
        return ID;
    }

    public ContentLocator generateContent(Repository repository, String path, StorageFileItem item) throws IllegalOperationException, ItemNotFoundException, LocalStorageException {
        ArtifactInfoFilter artifactInfoFilter = new ArtifactInfoFilter(){

            public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                return ArchetypeContentGenerator.this.indexArtifactFilter.filterArtifactInfo(ai);
            }
        };
        String exposedRepositoryContentUrl = this.repositoryURLBuilder.getExposedRepositoryContentUrl(repository);
        return new ArchetypeContentLocator(repository, exposedRepositoryContentUrl, this.indexerManager, this.macPlugin, artifactInfoFilter);
    }
}

