/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.logging.LoggingConfigurator;
import org.sonatype.nexus.logging.model.LoggerXO;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/logging/loggers")
public class LoggersResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/logging/loggers";
    private final LoggingConfigurator configurator;

    @Inject
    public LoggersResource(LoggingConfigurator configurator) {
        this.configurator = (LoggingConfigurator)Preconditions.checkNotNull((Object)configurator, (Object)"configurator");
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:logconfig:read"})
    public List<LoggerXO> get() {
        return Lists.newArrayList(this.configurator.getLoggers());
    }

    private static void checkLoggerName(String name) {
        Preconditions.checkArgument((boolean)name.equals(StringEscapeUtils.escapeHtml((String)name)), (Object)"Invalid logger name");
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:logconfig:update"})
    public LoggerXO post(LoggerXO logger) throws Exception {
        Preconditions.checkNotNull((Object)logger, (Object)"logger");
        Preconditions.checkNotNull((Object)((Object)logger.getLevel()), (Object)"logger level");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)logger.getName()), (Object)"name cannot be empty");
        LoggersResource.checkLoggerName(logger.getName());
        return logger.withLevel(this.configurator.setLevel(logger.getName(), logger.getLevel()));
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:logconfig:update"})
    public LoggerXO put(@PathParam(value="name") String name, LoggerXO logger) throws Exception {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        LoggersResource.checkLoggerName(name);
        Preconditions.checkNotNull((Object)logger, (Object)"logger");
        Preconditions.checkNotNull((Object)((Object)logger.getLevel()), (Object)"logger level");
        return logger.withLevel(this.configurator.setLevel(name, logger.getLevel()));
    }

    @DELETE
    @Path(value="/{name}")
    @RequiresPermissions(value={"nexus:logconfig:update"})
    public void delete(@PathParam(value="name") String name) throws Exception {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.configurator.remove(name);
    }

    @DELETE
    @RequiresPermissions(value={"nexus:logconfig:update"})
    public void reset() throws Exception {
        this.configurator.reset();
    }
}

