/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.log.LogManager;
import org.sonatype.nexus.log.LoggerLevel;
import org.sonatype.nexus.logging.model.MarkerXO;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/logging/log")
public class LogResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/logging/log";
    private static final Logger log = LoggerFactory.getLogger(LogResource.class);
    private final LogManager logManager;

    @Inject
    public LogResource(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    @GET
    @Produces(value={"text/plain"})
    @RequiresPermissions(value={"nexus:logs:read"})
    public Response get(@QueryParam(value="fromByte") Long fromByte, @QueryParam(value="bytesCount") Long bytesCount) throws Exception {
        Long count;
        Long from = fromByte;
        if (from == null || from < 0L) {
            from = 0L;
        }
        if ((count = bytesCount) == null) {
            count = Long.MAX_VALUE;
        }
        return Response.ok((Object)this.logManager.getApplicationLogAsStream("nexus.log", from.longValue(), count.longValue()).getInputStream()).header("Content-Disposition", (Object)"attachment; filename=\"nexus.log\"").build();
    }

    @PUT
    @Path(value="/mark")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:logconfig:update"})
    public void put(MarkerXO marker) throws Exception {
        Preconditions.checkNotNull((Object)marker);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)marker.getMessage()));
        this.logManager.setLoggerLevel(log.getName(), LoggerLevel.INFO);
        String asterixes = StringUtils.repeat((String)"*", (int)(marker.getMessage().length() + 4));
        log.info("\n" + asterixes + "\n" + "* " + marker.getMessage() + " *" + "\n" + asterixes);
    }
}

