/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.log.LogManager;
import org.sonatype.nexus.log.LoggerLevel;
import org.sonatype.nexus.logging.LoggingConfigurator;
import org.sonatype.nexus.logging.model.LevelXO;
import org.sonatype.nexus.logging.model.LoggerXO;

@Named
@Singleton
public class LoggingConfiguratorImpl
implements LoggingConfigurator {
    public static final String ROOT = "ROOT";
    private final LogManager logManager;
    private final ReadWriteLock lock;

    @Inject
    public LoggingConfiguratorImpl(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public Collection<LoggerXO> getLoggers() {
        ArrayList loggers = Lists.newArrayList();
        for (Map.Entry entry : this.logManager.getLoggers().entrySet()) {
            loggers.add(new LoggerXO().withName((String)entry.getKey()).withLevel(LevelXO.valueOf(((LoggerLevel)entry.getValue()).name())));
        }
        return loggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LevelXO setLevel(String name, LevelXO level) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)((Object)level), (Object)"level");
        try {
            this.lock.writeLock().lock();
            this.logManager.setLoggerLevel(name, LoggerLevel.valueOf((String)level.name()));
            LevelXO levelXO = LevelXO.valueOf(this.logManager.getLoggerEffectiveLevel(name).name());
            return levelXO;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkArgument((!ROOT.equals(name) ? 1 : 0) != 0, (Object)"ROOT logger cannot be removed");
        try {
            this.lock.writeLock().lock();
            this.logManager.unsetLoggerLevel(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void reset() {
        try {
            this.lock.writeLock().lock();
            this.logManager.resetLoggers();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

