/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.site.plugin.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.CUserRoleMapping;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.realms.tools.SecurityConfigurationModifier;

@Named
@Singleton
public class SiteRepositorySecurityConfigurationModifier
implements SecurityConfigurationModifier {
    private Map<String, String> roleMappings = Maps.newHashMap();
    private Map<String, String> privilegesMappings;

    public SiteRepositorySecurityConfigurationModifier() {
        this.roleMappings.put("maven-site-all-read", "site-all-read");
        this.roleMappings.put("maven-site-all-full", "site-all-full");
        this.roleMappings.put("maven-site-all-view", "site-all-view");
        this.privilegesMappings = Maps.newHashMap();
        this.privilegesMappings.put("maven-site-create", "site-create");
        this.privilegesMappings.put("maven-site-read", "site-read");
        this.privilegesMappings.put("maven-site-update", "site-update");
        this.privilegesMappings.put("maven-site-delete", "site-delete");
    }

    public boolean apply(Configuration configuration) {
        List userRoleMappings;
        List privileges;
        boolean modified = false;
        List roles = configuration.getRoles();
        if (roles != null && roles.size() > 0) {
            for (CRole role : roles) {
                List rolePrivileges;
                Object roleRole2;
                List roleRoles = role.getRoles();
                if (roleRoles != null && roleRoles.size() > 0) {
                    ArrayList newRoles = Lists.newArrayList();
                    for (Object roleRole2 : roleRoles) {
                        String newRole = this.roleMappings.get(roleRole2);
                        if (newRole != null) {
                            newRoles.add(newRole);
                            modified = true;
                            continue;
                        }
                        newRoles.add(roleRole2);
                    }
                    role.getRoles().clear();
                    role.getRoles().addAll(newRoles);
                }
                if ((rolePrivileges = role.getPrivileges()) == null || rolePrivileges.size() <= 0) continue;
                ArrayList newPrivileges = Lists.newArrayList();
                roleRole2 = rolePrivileges.iterator();
                while (roleRole2.hasNext()) {
                    String rolePrivilege = (String)roleRole2.next();
                    String newPrivilege = this.privilegesMappings.get(rolePrivilege);
                    if (newPrivilege != null) {
                        newPrivileges.add(newPrivilege);
                        modified = true;
                        continue;
                    }
                    newPrivileges.add(rolePrivilege);
                }
                role.getPrivileges().clear();
                role.getPrivileges().addAll(newPrivileges);
            }
        }
        if ((privileges = configuration.getPrivileges()) != null && privileges.size() > 0) {
            for (CPrivilege privilege : privileges) {
                List privilegeProps = privilege.getProperties();
                if (privilegeProps == null || privilegeProps.size() <= 0) continue;
                for (CProperty privilegeProp : privilegeProps) {
                    if (!"maven-site".equals(privilegeProp.getValue())) continue;
                    privilegeProp.setValue("site");
                    modified = true;
                }
            }
        }
        if ((userRoleMappings = configuration.getUserRoleMappings()) != null && userRoleMappings.size() > 0) {
            for (CUserRoleMapping userRoleMapping : userRoleMappings) {
                List userRoleMappingRoles = userRoleMapping.getRoles();
                if (userRoleMappingRoles == null || userRoleMappingRoles.size() <= 0) continue;
                ArrayList newRoles = Lists.newArrayList();
                for (String userRoleMappingRole : userRoleMappingRoles) {
                    String newRole = this.roleMappings.get(userRoleMappingRole);
                    if (newRole != null) {
                        newRoles.add(newRole);
                        modified = true;
                        continue;
                    }
                    newRoles.add(userRoleMappingRole);
                }
                userRoleMapping.getRoles().clear();
                userRoleMapping.getRoles().addAll(newRoles);
            }
        }
        return modified;
    }
}

