/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.site.plugin.config;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ConfigurationModifier;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryTarget;
import org.sonatype.nexus.configuration.model.Configuration;

@Named
@Singleton
public class SiteRepositoryConfigurationModifier
implements ConfigurationModifier {
    public boolean apply(Configuration configuration) {
        List repositoryTargets;
        boolean modified = false;
        List repositories = configuration.getRepositories();
        if (repositories != null && repositories.size() > 0) {
            for (CRepository repository : repositories) {
                if (!"maven-site".equals(repository.getProviderHint())) continue;
                repository.setProviderHint("site");
                modified = true;
            }
        }
        if ((repositoryTargets = configuration.getRepositoryTargets()) != null && repositoryTargets.size() > 0) {
            for (CRepositoryTarget repositoryTarget : repositoryTargets) {
                if ("maven-site".equals(repositoryTarget.getId())) {
                    repositoryTarget.setId("site");
                    modified = true;
                }
                if ("maven-site".equals(repositoryTarget.getContentClass())) {
                    repositoryTarget.setContentClass("site");
                    modified = true;
                }
                if (repositoryTarget.getName() == null || !repositoryTarget.getName().contains("maven-site")) continue;
                repositoryTarget.setName(repositoryTarget.getName().replace("maven-site", "site"));
                modified = true;
            }
        }
        return modified;
    }
}

