/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.site.plugin;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractWebSiteRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.repository.WebSiteRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.repository.site.plugin.DefaultSiteRepositoryConfiguration;
import org.sonatype.nexus.repository.site.plugin.SiteRepository;

@Named(value="site")
public class DefaultSiteRepository
extends AbstractWebSiteRepository
implements SiteRepository,
WebSiteRepository {
    private final ContentClass contentClass;
    private final Configurator repositoryConfigurator;
    private RepositoryKind repositoryKind;

    @Inject
    public DefaultSiteRepository(@Named(value="site") ContentClass contentClass, @Named(value="site") Configurator repositoryConfigurator) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.repositoryConfigurator = (Configurator)Preconditions.checkNotNull((Object)repositoryConfigurator);
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public RepositoryKind getRepositoryKind() {
        if (this.repositoryKind == null) {
            this.repositoryKind = new DefaultRepositoryKind(SiteRepository.class, null);
        }
        return this.repositoryKind;
    }

    protected CRepositoryExternalConfigurationHolderFactory<DefaultSiteRepositoryConfiguration> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<DefaultSiteRepositoryConfiguration>(){

            public DefaultSiteRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new DefaultSiteRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public Configurator getConfigurator() {
        return this.repositoryConfigurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeItem(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        request.pushRequestPath(DefaultSiteRepository.normalize(request.getRequestPath()));
        try {
            super.storeItem(request, is, userAttributes);
        }
        finally {
            request.popRequestPath();
        }
    }

    public void storeItem(boolean fromTask, StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        if (AbstractStorageItem.class.isAssignableFrom(item.getClass())) {
            String normalizedPath = DefaultSiteRepository.normalize(item.getPath());
            AbstractStorageItem fileItem = (AbstractStorageItem)item;
            fileItem.setPath(normalizedPath);
        }
        super.storeItem(fromTask, item);
    }

    private static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

