var http = require("http"),
    url = require("url"),
    qs = require('querystring'),
    body = '<html>'+
        '<head>'+
            '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">'+
            '<title>JTest</title>'+
            '<style type="text/css">'+
                '.button1{'+
                'width: 200px;'+
                'height: 50px;'+
            '}'+
            '.input1{'+
                   'width: 150px;'+
                   'text-align: center;'+
            '}'+
            '</style>'+
        '</head>'+
        '<body>'+
            '<center>'+
            '<h1>Welcome to JTest! (NodeJS)</h1>'+
            '<br>'+
            '<input type="button" value="CPU (1 min)" class="button1" onclick="load(\'cpu\', 60)"/>'+
            '<input type="button" value="CPU (3 min)" class="button1" onclick="load(\'cpu\', 180)"/>'+
            '<input type="button" value="CPU (5 min)" class="button1" onclick="load(\'cpu\', 300)"/>'+
            '<br><br>'+
            '<input type="button" value="MEM (1 min)" class="button1" onclick="loadmem(\'mem\', 60, 50)"/>'+
            '<input type="button" value="MEM (3 min)" class="button1" onclick="loadmem(\'mem\', 180, 50)"/>'+
            '<input type="button" value="MEM (5 min)" class="button1" onclick="loadmem(\'mem\', 300, 50)"/>'+
            '<br><br>'+
            '</center>'+
            '<script>'+
                'function load(par, sec){'+
                    'window.location="/" + par + "=1&sec=" + sec;'+
                '}'+
            'function loadmem(par, sec, percent){'+
                    'window.location="/" + par + "=1&sec=" + sec + "&percent=" + percent;'+
                '}'+
            '</script>'+
        '</body>'+
    '</html>';

function onRequest(request, response) {
  var pathname = url.parse(request.url).pathname;
  var qparams = qs.parse(pathname.substring(1));
  
  response.writeHead(200, {"Content-Type": "text/html"});
  
  if(qparams.cpu && qparams.sec){
    response.write("<center><h2>CPU load started on " + qparams.sec/60 + " min</h2></center>");
    
    require('child_process').exec('node load-cpu.js cpu ' + qparams.sec, function (err) {
        if (err) {process.exit(1);}
    });
    
  }
  
  if(qparams.mem && qparams.sec && qparams.percent){
    response.write("<center><h2>Memory load started on " + qparams.sec/60 + " min with " + qparams.percent + "% percent load</h2></center>");
    require('child_process').exec('node load-mem.js mem ' + qparams.sec + ' ' + qparams.percent, function (err) {
        if (err) {process.exit(1);}
    });
  }

  response.write(body);

  response.end();
}

http.createServer(onRequest).listen(8888);