<?php
  $nameDb = $_GET['nameDb'];
  date_default_timezone_set('UTC');
  try {
    $file_db = new PDO("sqlite:$nameDb");
    $file_db->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
 
    $memory_db = new PDO('sqlite::memory:');
    $memory_db->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
 
    $file_db->exec("CREATE TABLE IF NOT EXISTS messages (
                    id INTEGER PRIMARY KEY, 
                    title TEXT, 
                    message TEXT, 
                    time INTEGER)");
    $memory_db->exec("CREATE TABLE messages (
                      id INTEGER PRIMARY KEY, 
                      title TEXT, 
                      message TEXT, 
                      time TEXT)");
    
    $messages = array(
                  array('title' => 'OK!!!! PHP module "pdo.so,pdo_sqlite.so" works!!!!',
                        'message' => 'Just testing...',
                        'time' => 1327301464)
                );
    $insert = "INSERT INTO messages (title, message, time) 
                VALUES (:title, :message, :time)";
    $stmt = $file_db->prepare($insert);
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':message', $message);
    $stmt->bindParam(':time', $time);
    foreach ($messages as $m) {
      $title = $m['title'];
      $message = $m['message'];
      $time = $m['time'];
      $stmt->execute();
    }
    $insert = "INSERT INTO messages (id, title, message, time) 
                VALUES (:id, :title, :message, :time)";
    $stmt = $memory_db->prepare($insert);
    $result = $file_db->query('SELECT * FROM messages');
    foreach ($result as $m) {
      $stmt->bindValue(':id', $m['id'], SQLITE3_INTEGER);
      $stmt->bindValue(':title', $m['title'], SQLITE3_TEXT);
      $stmt->bindValue(':message', $m['message'], SQLITE3_TEXT);
      $formatted_time = date('Y-m-d H:i:s', $m['time']);
      $stmt->bindValue(':time', $formatted_time, SQLITE3_TEXT);
      $stmt->execute();
    }
 
    $new_title = $memory_db->quote("Hi''\'''\\\"\"!'\"");
    $update = "UPDATE messages SET title = {$new_title} 
                WHERE datetime(time) > 
                datetime('2012-06-01 15:48:07')";
    $memory_db->exec($update);
    $result = $memory_db->query('SELECT * FROM messages');
 
    foreach($result as $row) {
      echo "Id: " . $row['id'] . "\n";
      echo "Title: " . $row['title'] . "\n";
      echo "Message: " . $row['message'] . "\n";
      echo "Time: " . $row['time'] . "\n";
      echo "\n";
    }
 
    $file_db->exec("DROP TABLE messages");
    $memory_db->exec("DROP TABLE messages");
 
    $file_db = null;
    $memory_db = null;
  }
  catch(PDOException $e) {
    echo "Error!!!! PHP module 'pdo.so,pdo_sqlite.so' does not work!!!!";
    echo $e->getMessage();
  }
?>
