<?php
$test = true;
$subject = array(
  "commonName" => "docs.php.net",
  "stateOrProvinceName" => "TestState",
  "countryName" => "US",
  "organizationName" => "testOrg",
  "localityName" => "PHP Test",
);
$private_key = openssl_pkey_new(array(
  "private_key_type" => OPENSSL_KEYTYPE_EC,
  "curve_name" => 'prime256v1',
));
if ($private_key === false ){
  	echo "Can't create private key<br />\n";
	exit ("Error!!!! PHP module 'openssl.so' does not work!!!!");
}
$csr = openssl_csr_new($subject, $private_key, array('digest_alg' => 'sha384'));
if ($csr === false ){
   	echo "Can't create CSR<br />\n";
	exit ( "Error!!!! PHP module 'openssl.so' does not work!!!!");
}
$x509 = openssl_csr_sign($csr, null, $private_key, $days=365, array('digest_alg' => 'sha384'));
if ($x509 === false ){
   	echo "Can't sign a CSR <br />\n";
	exit ( "Error!!!! PHP module 'openssl.so' does not work!!!!");
}
//    openssl_x509_export_to_file($x509, 'ecc-cert.pem');
//    openssl_pkey_export_to_file($private_key, 'ecc-private.key');
//    echo $private_key;
$pubKey = openssl_pkey_get_details($private_key);
echo "<pre>";
print_r($pubKey);
print_r(openssl_csr_get_subject($csr,$use_shortnames = false));
echo "</pre>";
$csr_data = openssl_csr_get_subject($csr,$use_shortnames = false);
foreach ($csr_data as $ckey => $cval){
	//echo "$ckey => $cval\n<br>";
  if ($subject[$ckey] != $cval) {
  	echo "SUBJKEY: $subject[$ckey] \t";
    echo " val:  $cval | $ckey<br />\n";
    $test = false;
  }
}
echo "\n<br /><br />\n";
//$pos = strrpos(print_r($private_key, true), "id #2");
if ($test === false) {
  echo "Error!!!! PHP module 'openssl.so' does not work!!!!";
} else {
  echo "OK!!!! PHP module 'openssl.so' works!!!!";
}
?>
