from fastapi import FastAPI, WebSocket
from fastapi.responses import HTMLResponse
import argparse 
import logging

app = FastAPI()
uvicorn_logger = logging.getLogger("uvicorn")
uvicorn_logger.setLevel(logging.INFO)

html = """
<!DOCTYPE html>
<html><head><title>WebSocket Chat</title></head><body>
<h1>WebSocket Chat</h1><input id="messageInput" type="text" placeholder="Type a message..." />
<button onclick="sendMessage()">Send</button><ul id="messages"></ul>
    <script>
        let ws = new WebSocket("ws://" + window.location.host + "/ws");
        ws.onmessage = function(event) {
            let messages = document.getElementById('messages');
            let message = document.createElement('li');
            message.textContent = event.data;
            messages.appendChild(message);
        };
        function sendMessage() {
            let input = document.getElementById("messageInput");
            ws.send(input.value);
            input.value = '';
        }
    </script></body></html>
"""

@app.get("/")
async def get():
    return HTMLResponse(html)

@app.websocket("/ws")
async def websocket_endpoint(websocket: WebSocket):
    await websocket.accept()
    try:
        while True:
            data = await websocket.receive_text()
            uvicorn_logger.info(f"Message received: {data}")
            await websocket.send_text(f"Message received: {data}")
    except Exception as e:
        print(f"WebSocket error: {e}")
parser = argparse.ArgumentParser()
parser.add_argument("--port", help="Port", type=int, default=4848)
args = parser.parse_args()

if __name__ == "__main__":
    import uvicorn
    uvicorn.run(app, host="0.0.0.0", port=args.port,
                ssl_keyfile="key.pem", 
                ssl_certfile="cert.pem"
               )

